/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events.annotation;

import ch.squaredesk.nova.events.annotation.EventContext;
import io.reactivex.functions.Consumer;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandlingMethodInvoker
implements Consumer<Object[]> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventHandlingMethodInvoker.class);
    private final Object objectToInvokeMethodOn;
    private final Method methodToInvoke;
    private final EventContext eventContext;
    private final boolean injectEventContext;

    EventHandlingMethodInvoker(Object objectToInvokeMethodOn, Method methodToInvoke, EventContext eventContext) {
        this.objectToInvokeMethodOn = objectToInvokeMethodOn;
        this.methodToInvoke = methodToInvoke;
        this.eventContext = eventContext;
        Class<?> classOfLastParameter = methodToInvoke.getParameterTypes()[methodToInvoke.getParameterTypes().length - 1];
        this.injectEventContext = classOfLastParameter == EventContext.class;
    }

    public void accept(Object ... data) {
        Object[] parameterArray = this.createParameterArrayFromEventEmitterData(this.methodToInvoke.getParameterCount(), data);
        try {
            if (parameterArray == null) {
                this.methodToInvoke.invoke(this.objectToInvokeMethodOn, new Object[0]);
            } else {
                this.methodToInvoke.invoke(this.objectToInvokeMethodOn, parameterArray);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to invoke event Handler");
            LOGGER.error("\tParameters: ");
            if (data != null) {
                Arrays.stream(data).forEach(param -> LOGGER.error("\t\t" + param));
                LOGGER.error("\t\tnull");
            } else {
                LOGGER.error("\t\tnull");
            }
            LOGGER.error("\tException: ", (Throwable)e);
        }
    }

    private Object[] createParameterArrayFromEventEmitterData(int numParametersForMethodCall, Object ... dataArray) {
        if (numParametersForMethodCall == 0) {
            return null;
        }
        Object[] retVal = new Object[numParametersForMethodCall];
        if (dataArray != null) {
            int numElementsToCopyFromDataArray = Math.min(retVal.length, dataArray.length);
            System.arraycopy(dataArray, 0, retVal, 0, numElementsToCopyFromDataArray);
        }
        if (this.injectEventContext) {
            retVal[retVal.length - 1] = this.eventContext;
        }
        return retVal;
    }
}

