/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events.annotation;

import ch.squaredesk.nova.events.annotation.EventHandlerDescription;
import ch.squaredesk.nova.events.annotation.OnEvent;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;

class BeanExaminer {
    BeanExaminer() {
    }

    EventHandlerDescription[] examine(Object bean) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        Method[] methods = bean.getClass().getMethods();
        return (EventHandlerDescription[])Arrays.stream(methods).filter(m -> m.isAnnotationPresent(OnEvent.class)).peek(m -> {
            if (m.getAnnotation(OnEvent.class).value().length == 0) {
                throw new IllegalArgumentException("Invalid annotation definition: no event key provided");
            }
        }).map(m -> {
            OnEvent annotation = m.getAnnotation(OnEvent.class);
            return new EventHandlerDescription(bean, (Method)m, annotation.value(), annotation.backpressureStrategy(), annotation.dispatchOnBusinessLogicThread(), annotation.enableInvocationTimeMetrics());
        }).toArray(EventHandlerDescription[]::new);
    }
}

