/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.events.annotation;

import ch.squaredesk.nova.Nova;
import io.reactivex.BackpressureStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class NovaProvidingConfiguration {
    @Autowired
    private Environment environment;

    @Bean(name={"nova"})
    public Nova nova() {
        return Nova.builder().setIdentifier(this.identifier()).setDefaultBackpressureStrategy(this.defaultBackpressureStrategy()).setWarnOnUnhandledEvent(this.warnOnUnhandledEvent().booleanValue()).build();
    }

    @Bean
    public String identifier() {
        return this.environment.getProperty("NOVA.ID", "");
    }

    @Bean
    public Boolean warnOnUnhandledEvent() {
        return (Boolean)this.environment.getProperty("NOVA.EVENTS.WARN_ON_UNHANDLED", Boolean.class, (Object)false);
    }

    @Bean
    public BackpressureStrategy defaultBackpressureStrategy() {
        String strategyAsString = (String)this.environment.getProperty("NOVA.EVENTS.BACKPRESSURE_STRATEGY", String.class, (Object)BackpressureStrategy.BUFFER.toString());
        return BackpressureStrategy.valueOf((String)strategyAsString.toUpperCase());
    }
}

