/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http.spring;

import ch.squaredesk.nova.Nova;
import ch.squaredesk.nova.comm.http.HttpServerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
public class HttpServerConfigurationProvidingConfiguration {
    @Autowired
    Environment environment;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    Nova nova;

    @Bean(value={"httpServerPort"})
    public Integer httpServerPort() {
        return (Integer)this.environment.getProperty("NOVA.HTTP.SERVER.PORT", Integer.class, (Object)10000);
    }

    @Bean(value={"httpServerInterfaceName"})
    public String interfaceName() {
        return this.environment.getProperty("NOVA.HTTP.SERVER.INTERFACE_NAME", "0.0.0.0");
    }

    @Bean(value={"httpServerTrustStore"})
    public String sslTrustStorePass() {
        return this.environment.getProperty("NOVA.HTTP.SERVER.TRUST_STORE");
    }

    @Bean(value={"httpServerTrustStorePass"})
    public String sslTrustStorePath() {
        return this.environment.getProperty("NOVA.HTTP.SERVER.TRUST_STORE_PASS");
    }

    @Bean(value={"httpServerKeyStore"})
    public String sslKeyStorePass() {
        return this.environment.getProperty("NOVA.HTTP.SERVER.KEY_STORE");
    }

    @Bean(value={"httpServerKeyStorePass"})
    public String sslKeyStorePath() {
        return this.environment.getProperty("NOVA.HTTP.SERVER.KEY_STORE_PASS");
    }

    @Bean(value={"httpServerConfiguration"})
    public HttpServerConfiguration httpServerConfiguration() {
        return HttpServerConfiguration.builder().interfaceName(this.interfaceName()).port(this.httpServerPort().intValue()).sslKeyStorePath(this.sslKeyStorePath()).sslKeyStorePass(this.sslKeyStorePass()).sslTrustStorePath(this.sslTrustStorePath()).sslTrustStorePass(this.sslTrustStorePass()).build();
    }
}

