/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http.spring;

import java.io.IOException;
import org.glassfish.grizzly.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class HttpServerStarter
implements ApplicationListener<ContextRefreshedEvent>,
DisposableBean {
    private Logger logger = LoggerFactory.getLogger(HttpServerStarter.class);
    private HttpServer httpServer;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.httpServer = (HttpServer)event.getApplicationContext().getBean("httpServer", HttpServer.class);
        if (!this.httpServer.isStarted()) {
            try {
                this.httpServer.start();
            }
            catch (IOException e) {
                this.logger.error("Unable to start HttpServer", (Throwable)e);
            }
        }
    }

    public void destroy() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }
}

