/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpRequestSender {
    private HttpRequestSender() {
    }

    public static HttpResponse sendPutRequest(String url, String request) throws IOException {
        return HttpRequestSender.sendPutRequest(new URL(url), request, null);
    }

    public static HttpResponse sendPutRequest(String url, String request, String contentType) throws IOException {
        return HttpRequestSender.sendPutRequest(new URL(url), request, contentType);
    }

    public static HttpResponse sendPutRequest(URL url, String request) throws IOException {
        return HttpRequestSender.sendPutRequest(url, request, null);
    }

    public static HttpResponse sendPutRequest(URL url, String request, String contentType) throws IOException {
        return HttpRequestSender.sendRequest("PUT", url, request, contentType);
    }

    public static HttpResponse sendPostRequest(String url, String request) throws IOException {
        return HttpRequestSender.sendPostRequest(new URL(url), request, null);
    }

    public static HttpResponse sendPostRequest(String url, String request, String contentType) throws IOException {
        return HttpRequestSender.sendPostRequest(new URL(url), request, contentType);
    }

    public static HttpResponse sendPostRequest(URL url, String request) throws IOException {
        return HttpRequestSender.sendPostRequest(url, request, null);
    }

    public static HttpResponse sendPostRequest(URL url, String request, String contentType) throws IOException {
        return HttpRequestSender.sendRequest("POST", url, request, contentType);
    }

    public static HttpResponse sendGetRequest(String url) throws IOException {
        return HttpRequestSender.sendGetRequest(new URL(url));
    }

    public static HttpResponse sendGetRequest(URL url) throws IOException {
        return HttpRequestSender.sendRequest("GET", url, null, null);
    }

    public static HttpResponse sendRequest(String method, URL url, String request, String contentType) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if ("POST".equals(method) || "PUT".equals(method)) {
            connection.setDoOutput(true);
        }
        connection.setRequestMethod(method);
        String charset = "UTF-8";
        connection.setRequestProperty("Accept-Charset", charset);
        if (contentType != null) {
            connection.setRequestProperty("Content-Type", "application/json");
        } else {
            connection.setRequestProperty("Content-Type", "text/plain");
        }
        if (request != null) {
            try (OutputStream output = connection.getOutputStream();){
                output.write(request.getBytes(charset));
            }
        }
        connection.connect();
        StringBuilder sb = new StringBuilder();
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode > 299) {
            if (connection.getErrorStream() != null) {
                BufferedReader errorReader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));
                while (errorReader.ready()) {
                    sb.append(errorReader.readLine()).append('\n');
                }
                errorReader.close();
                return new HttpResponse(responseCode, sb.toString().trim());
            }
            return new HttpResponse(responseCode, connection.getResponseMessage());
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        while (reader.ready()) {
            sb.append(reader.readLine()).append('\n');
        }
        reader.close();
        return new HttpResponse(responseCode, sb.toString().trim());
    }

    public static class HttpResponse {
        public final int returnCode;
        public final String replyMessage;

        public HttpResponse(int returnCode, String replyMessage) {
            this.returnCode = returnCode;
            this.replyMessage = replyMessage;
        }
    }
}

