/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Consumer;

public class SimpleHttpServer
implements AutoCloseable {
    private final HttpServer delegate;

    private SimpleHttpServer(int port, String path, Consumer<HttpExchange> exchangeConsumer) throws IOException {
        this.delegate = HttpServer.create(new InetSocketAddress(port), 0);
        this.delegate.createContext(path, new MyHandler(exchangeConsumer));
        this.delegate.setExecutor(null);
        this.delegate.start();
    }

    public static SimpleHttpServer create(int port, String path, Consumer<HttpExchange> exchangeConsumer) throws IOException {
        return new SimpleHttpServer(port, path, exchangeConsumer);
    }

    @Override
    public void close() throws Exception {
        if (this.delegate != null) {
            this.delegate.stop(0);
        }
    }

    private static class MyHandler
    implements HttpHandler {
        private final Consumer<HttpExchange> exchangeConsumer;

        private MyHandler(Consumer<HttpExchange> exchangeConsumer) {
            this.exchangeConsumer = Objects.requireNonNull(exchangeConsumer);
        }

        @Override
        public void handle(HttpExchange t) {
            this.exchangeConsumer.accept(t);
        }
    }
}

