/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.HttpRpcInvocation;
import ch.squaredesk.nova.comm.http.HttpSpecificInfo;
import ch.squaredesk.nova.comm.http.RpcClient;
import ch.squaredesk.nova.comm.http.RpcServer;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import com.ning.http.client.AsyncHttpClient;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAdapter<MessageType> {
    private final RpcClient<MessageType> rpcClient;
    private final RpcServer<MessageType> rpcServer;
    private final Long defaultRequestTimeout;
    private final TimeUnit defaultRequestTimeUnit;

    private HttpAdapter(Builder<MessageType> builder) {
        this.rpcClient = ((Builder)builder).rpcClient;
        this.rpcServer = ((Builder)builder).rpcServer;
        this.defaultRequestTimeout = ((Builder)builder).defaultRequestTimeout;
        this.defaultRequestTimeUnit = ((Builder)builder).defaultRequestTimeUnit;
    }

    public <ReplyMessageType extends MessageType> Single<ReplyMessageType> sendGetRequest(String destination) {
        return this.sendRequest(destination, null, new HttpSpecificInfo(HttpRequestMethod.GET), null, null);
    }

    public <ReplyMessageType extends MessageType> Single<ReplyMessageType> sendGetRequest(String destination, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new HttpSpecificInfo(HttpRequestMethod.GET), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendPostRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(HttpRequestMethod.POST), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendPostRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(HttpRequestMethod.POST), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendPutRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(HttpRequestMethod.PUT), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendPutRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(HttpRequestMethod.PUT), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, null, null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, (HttpRequestMethod)null, timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendRequest(String destination, RequestMessageType request, HttpRequestMethod requestMethod) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(requestMethod), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendRequest(String destination, RequestMessageType request, HttpRequestMethod requestMethod, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new HttpSpecificInfo(requestMethod), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<ReplyMessageType> sendRequest(String destination, RequestMessageType request, HttpSpecificInfo httpInfo, Long timeout, TimeUnit timeUnit) {
        URL url;
        if (timeout != null) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null if timeout specified");
        } else {
            timeout = this.defaultRequestTimeout;
            timeUnit = this.defaultRequestTimeUnit;
        }
        try {
            url = new URL(destination);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL format " + destination, e);
        }
        MessageSendingInfo sendingInfo = new MessageSendingInfo.Builder().withTransportSpecificInfo((Object)httpInfo).withDestination((Object)url).build();
        return this.rpcClient.sendRequest(request, (MessageSendingInfo<URL, HttpSpecificInfo>)sendingInfo, timeout, timeUnit);
    }

    public Flowable<HttpRpcInvocation<MessageType>> requests(String destination) {
        return this.rpcServer.requests(destination);
    }

    public void start() throws Exception {
        this.rpcServer.start();
    }

    public void shutdown() {
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.rpcClient.shutdown();
    }

    public static <MessageType> Builder<MessageType> builder(Class<MessageType> messageTypeClass) {
        return new Builder(messageTypeClass);
    }

    public static class Builder<MessageType>
    extends CommAdapterBuilder<MessageType, HttpAdapter<MessageType>> {
        private static Logger logger = LoggerFactory.getLogger(Builder.class);
        private String identifier;
        private HttpServer httpServer;
        private RpcClient<MessageType> rpcClient;
        private RpcServer<MessageType> rpcServer;
        private Long defaultRequestTimeout;
        private TimeUnit defaultRequestTimeUnit;

        private Builder(Class<MessageType> messageTypeClass) {
            super(messageTypeClass);
        }

        public Builder<MessageType> setDefaultRequestTimeout(long timeout, TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            if (timeout > 0L) {
                this.defaultRequestTimeout = timeout;
                this.defaultRequestTimeUnit = timeUnit;
            }
            return this;
        }

        public Builder<MessageType> setHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public Builder<MessageType> setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        protected void validate() {
            if (this.defaultRequestTimeout == null) {
                this.defaultRequestTimeout = 5L;
                this.defaultRequestTimeUnit = TimeUnit.SECONDS;
            }
        }

        public HttpAdapter<MessageType> createInstance() {
            this.validate();
            AsyncHttpClient httpClient = new AsyncHttpClient();
            this.rpcClient = new RpcClient(this.identifier, httpClient, this.messageMarshaller, this.messageUnmarshaller, this.metrics);
            if (this.httpServer == null) {
                logger.info("No httpServer provided, HTTP Adapter will only be usable in client mode!!!");
            } else {
                this.rpcServer = new RpcServer(this.identifier, this.httpServer, this.messageMarshaller, this.messageUnmarshaller, this.metrics);
            }
            return new HttpAdapter(this);
        }
    }
}

