/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.HttpSpecificInfo;
import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import ch.squaredesk.nova.metrics.Metrics;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.exceptions.Exceptions;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class RpcClient<InternalMessageType>
extends ch.squaredesk.nova.comm.rpc.RpcClient<URL, InternalMessageType, HttpSpecificInfo> {
    private final AsyncHttpClient client;
    private final MessageMarshaller<InternalMessageType, String> messageMarshaller;
    private final MessageUnmarshaller<String, InternalMessageType> messageUnmarshaller;

    RpcClient(String identifier, AsyncHttpClient client, MessageMarshaller<InternalMessageType, String> messageMarshaller, MessageUnmarshaller<String, InternalMessageType> messageUnmarshaller, Metrics metrics) {
        super(identifier, metrics);
        this.client = client;
        this.messageUnmarshaller = messageUnmarshaller;
        this.messageMarshaller = messageMarshaller;
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(RequestType request, MessageSendingInfo<URL, HttpSpecificInfo> messageSendingInfo, long timeout, TimeUnit timeUnit) {
        String requestAsString;
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        try {
            requestAsString = request != null ? (String)this.messageMarshaller.marshal(request) : null;
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
        AsyncHttpClient.BoundRequestBuilder requestBuilder = ((HttpSpecificInfo)messageSendingInfo.transportSpecificInfo).requestMethod == HttpRequestMethod.POST ? this.client.preparePost(((URL)messageSendingInfo.destination).toString()).setBody(requestAsString) : (((HttpSpecificInfo)messageSendingInfo.transportSpecificInfo).requestMethod == HttpRequestMethod.PUT ? this.client.preparePut(((URL)messageSendingInfo.destination).toString()).setBody(requestAsString) : (((HttpSpecificInfo)messageSendingInfo.transportSpecificInfo).requestMethod == HttpRequestMethod.DELETE ? this.client.prepareDelete(((URL)messageSendingInfo.destination).toString()).setBody(requestAsString) : this.client.prepareGet(((URL)messageSendingInfo.destination).toString())));
        ListenableFuture resultFuture = requestBuilder.addHeader("Content-Type", "application/json; charset=utf-8").execute();
        Single timeoutSingle = Single.timer((long)timeout, (TimeUnit)timeUnit).map(zero -> {
            TimeoutException te = new TimeoutException("Request" + (request == null ? "" : "" + String.valueOf(request)) + " to " + messageSendingInfo.destination + " ran into timeout after " + timeout + " " + String.valueOf((Object)timeUnit).toLowerCase());
            this.metricsCollector.rpcTimedOut((Object)((URL)messageSendingInfo.destination).toExternalForm());
            resultFuture.abort((Throwable)te);
            Exceptions.propagate((Throwable)te);
            return null;
        });
        Single resultSingle = Single.fromFuture((Future)resultFuture).map(response -> {
            int statusCode = response.getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                throw new RuntimeException("" + statusCode + " - " + response.getStatusText());
            }
            String responseBody = response.getResponseBody();
            this.metricsCollector.rpcCompleted(messageSendingInfo.destination, (Object)responseBody);
            return this.messageUnmarshaller.unmarshal((Object)responseBody);
        });
        return timeoutSingle.ambWith((SingleSource)resultSingle);
    }

    void shutdown() {
        this.client.close();
    }
}

