/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.ReplyInfo;
import ch.squaredesk.nova.comm.http.ReplyMessageMetaData;
import ch.squaredesk.nova.comm.http.RequestInfo;
import ch.squaredesk.nova.comm.http.RequestMessageMetaData;
import ch.squaredesk.nova.comm.http.RpcReply;
import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.metrics.Metrics;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import io.reactivex.Single;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RpcClient<InternalMessageType>
extends ch.squaredesk.nova.comm.rpc.RpcClient<InternalMessageType, RequestMessageMetaData, ReplyMessageMetaData> {
    private final AsyncHttpClient client;
    private final MessageMarshaller<InternalMessageType, String> messageMarshaller;
    private final MessageUnmarshaller<String, InternalMessageType> messageUnmarshaller;

    protected RpcClient(String identifier, AsyncHttpClient client, MessageMarshaller<InternalMessageType, String> messageMarshaller, MessageUnmarshaller<String, InternalMessageType> messageUnmarshaller, Metrics metrics) {
        super(identifier, metrics);
        this.client = client;
        this.messageUnmarshaller = messageUnmarshaller;
        this.messageMarshaller = messageMarshaller;
    }

    public <ReplyType extends InternalMessageType> Single<RpcReply<ReplyType>> sendRequest(InternalMessageType request, RequestMessageMetaData requestMessageMetaData, long timeout, TimeUnit timeUnit) {
        String requestAsString;
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        try {
            requestAsString = request != null ? (String)this.messageMarshaller.marshal(request) : null;
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
        AsyncHttpClient.BoundRequestBuilder requestBuilder = ((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.POST ? this.client.preparePost(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : (((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.PUT ? this.client.preparePut(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : (((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.DELETE ? this.client.prepareDelete(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : this.client.prepareGet(((URL)requestMessageMetaData.destination).toString())));
        ListenableFuture resultFuture = requestBuilder.addHeader("Content-Type", "application/json; charset=utf-8").execute();
        Single resultSingle = Single.fromFuture((Future)resultFuture).map(response -> {
            int statusCode = response.getStatusCode();
            ReplyMessageMetaData metaData = new ReplyMessageMetaData((URL)requestMessageMetaData.destination, new ReplyInfo(statusCode));
            String responseBody = response.getResponseBody();
            this.metricsCollector.rpcCompleted(requestMessageMetaData.destination, (Object)responseBody);
            return new RpcReply<Object>(this.messageUnmarshaller.unmarshal((Object)responseBody), metaData);
        });
        return resultSingle.timeout(timeout, timeUnit);
    }

    void shutdown() {
        this.client.close();
    }
}

