/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.RequestInfo;
import ch.squaredesk.nova.comm.http.RequestMessageMetaData;
import ch.squaredesk.nova.comm.http.RpcClient;
import ch.squaredesk.nova.comm.http.RpcInvocation;
import ch.squaredesk.nova.comm.http.RpcReply;
import ch.squaredesk.nova.comm.http.RpcServer;
import com.ning.http.client.AsyncHttpClient;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAdapter<MessageType> {
    private final RpcClient<MessageType> rpcClient;
    private final RpcServer<MessageType> rpcServer;
    private final Long defaultRequestTimeout;
    private final TimeUnit defaultRequestTimeUnit;

    private HttpAdapter(Builder<MessageType> builder) {
        this.rpcClient = ((Builder)builder).rpcClient;
        this.rpcServer = ((Builder)builder).rpcServer;
        this.defaultRequestTimeout = ((Builder)builder).defaultRequestTimeout;
        this.defaultRequestTimeUnit = ((Builder)builder).defaultRequestTimeUnit;
    }

    public <ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendGetRequest(String destination) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), null, null);
    }

    public <ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendGetRequest(String destination, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendPostRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendPostRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendPutRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendPutRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendRequest(String destination, RequestMessageType request) {
        return this.sendRequest(destination, request, null, null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendRequest(String destination, RequestMessageType request, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, (HttpRequestMethod)null, timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendRequest(String destination, RequestMessageType request, HttpRequestMethod requestMethod) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), null, null);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendRequest(String destination, RequestMessageType request, HttpRequestMethod requestMethod, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), (Long)timeout, timeUnit);
    }

    public <RequestMessageType extends MessageType, ReplyMessageType extends MessageType> Single<RpcReply<ReplyMessageType>> sendRequest(String destination, RequestMessageType request, RequestInfo httpInfo, Long timeout, TimeUnit timeUnit) {
        URL url;
        if (timeout != null) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null if timeout specified");
        } else {
            timeout = this.defaultRequestTimeout;
            timeUnit = this.defaultRequestTimeUnit;
        }
        try {
            url = new URL(destination);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL format " + destination, e);
        }
        RequestMessageMetaData sendingInfo = new RequestMessageMetaData(url, httpInfo);
        return this.rpcClient.sendRequest(request, sendingInfo, (long)timeout, timeUnit);
    }

    public Flowable<RpcInvocation<MessageType>> requests(String destination) {
        return this.rpcServer.requests(destination);
    }

    public void start() throws Exception {
        this.rpcServer.start();
    }

    public void shutdown() {
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.rpcClient.shutdown();
    }

    public static <MessageType> Builder<MessageType> builder(Class<MessageType> messageTypeClass) {
        return new Builder(messageTypeClass);
    }

    public static class Builder<MessageType>
    extends CommAdapterBuilder<MessageType, HttpAdapter<MessageType>> {
        private static Logger logger = LoggerFactory.getLogger(Builder.class);
        private String identifier;
        private HttpServer httpServer;
        private RpcClient<MessageType> rpcClient;
        private RpcServer<MessageType> rpcServer;
        private Long defaultRequestTimeout;
        private TimeUnit defaultRequestTimeUnit;

        private Builder(Class<MessageType> messageTypeClass) {
            super(messageTypeClass);
        }

        public Builder<MessageType> setDefaultRequestTimeout(long timeout, TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            if (timeout > 0L) {
                this.defaultRequestTimeout = timeout;
                this.defaultRequestTimeUnit = timeUnit;
            }
            return this;
        }

        public Builder<MessageType> setHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public Builder<MessageType> setRpcServer(RpcServer<MessageType> rpcServer) {
            this.rpcServer = rpcServer;
            return this;
        }

        public Builder<MessageType> setRpcClient(RpcClient<MessageType> rpcClient) {
            this.rpcClient = rpcClient;
            return this;
        }

        public Builder<MessageType> setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        protected void validate() {
        }

        protected HttpAdapter<MessageType> createInstance() {
            this.validate();
            if (this.defaultRequestTimeout == null) {
                this.defaultRequestTimeout = 15L;
                this.defaultRequestTimeUnit = TimeUnit.SECONDS;
            }
            if (this.rpcClient == null) {
                AsyncHttpClient httpClient = new AsyncHttpClient();
                this.rpcClient = new RpcClient(this.identifier, httpClient, this.messageMarshaller, this.messageUnmarshaller, this.metrics);
            }
            if (this.rpcServer == null) {
                if (this.httpServer == null) {
                    logger.info("No httpServer provided, HTTP Adapter will only be usable in client mode!!!");
                } else {
                    this.rpcServer = new RpcServer(this.identifier, this.httpServer, this.messageMarshaller, this.messageUnmarshaller, this.metrics);
                }
            }
            return new HttpAdapter(this);
        }
    }
}

