/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.http.HttpAdapter;
import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.RpcReply;
import io.reactivex.Single;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class FrozenHttpAdapter<T> {
    private final HttpAdapter delegate;
    private final Class<T> freezeType;

    FrozenHttpAdapter(HttpAdapter delegate, Class<T> freezeType) {
        this.delegate = delegate;
        this.freezeType = freezeType;
    }

    public void shutdown() {
        this.delegate.shutdown();
    }

    public Single<RpcReply<T>> sendGetRequest(String destination) {
        return this.delegate.sendGetRequest(destination, this.freezeType);
    }

    public Single<RpcReply<T>> sendGetRequest(String destination, Map<String, String> headers) {
        return this.delegate.sendGetRequest(destination, headers, this.freezeType);
    }

    public Single<RpcReply<T>> sendGetRequest(String destination, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendGetRequest(destination, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendGetRequest(String destination, Map<String, String> headers, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendGetRequest(destination, headers, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendPostRequest(String destination, T request) {
        return this.delegate.sendPostRequest(destination, request, this.freezeType);
    }

    public Single<RpcReply<T>> sendPostRequest(String destination, Map<String, String> headers, T request) {
        return this.delegate.sendPostRequest(destination, request, headers, this.freezeType);
    }

    public Single<RpcReply<T>> sendPostRequest(String destination, T request, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendPostRequest(destination, request, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendPostRequest(String destination, T request, Map<String, String> headers, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendPostRequest(destination, request, headers, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendPutRequest(String destination, T request) {
        return this.delegate.sendPutRequest(destination, request, this.freezeType);
    }

    public Single<RpcReply<T>> sendPutRequest(String destination, Map<String, String> headers, T request) {
        return this.delegate.sendPutRequest(destination, request, headers, this.freezeType);
    }

    public Single<RpcReply<T>> sendPutRequest(String destination, T request, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendPutRequest(destination, request, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendPutRequest(String destination, Map<String, String> headers, T request, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendPutRequest(destination, request, headers, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendDeleteRequest(String destination, T request) {
        return this.delegate.sendDeleteRequest(destination, request, this.freezeType);
    }

    public Single<RpcReply<T>> sendDeleteRequest(String destination, Map<String, String> headers, T request) {
        return this.delegate.sendDeleteRequest(destination, request, headers, this.freezeType);
    }

    public Single<RpcReply<T>> sendDeleteRequest(String destination, T request, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendDeleteRequest(destination, request, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendDeleteRequest(String destination, T request, Map<String, String> headers, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendDeleteRequest(destination, request, headers, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendRequest(String destination, T request, HttpRequestMethod requestMethod) {
        return this.delegate.sendRequest(destination, request, requestMethod, this.freezeType);
    }

    public Single<RpcReply<T>> sendRequest(String destination, T request, Map<String, String> headers, HttpRequestMethod requestMethod) {
        return this.delegate.sendRequest(destination, request, requestMethod, headers, this.freezeType);
    }

    public Single<RpcReply<T>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendRequest(destination, request, requestMethod, this.freezeType, timeout, timeUnit);
    }

    public Single<RpcReply<T>> sendRequest(String destination, T request, Map<String, String> headers, HttpRequestMethod requestMethod, long timeout, TimeUnit timeUnit) {
        return this.delegate.sendRequest(destination, request, requestMethod, headers, this.freezeType, timeout, timeUnit);
    }
}

