/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.ReplyInfo;
import ch.squaredesk.nova.comm.http.ReplyMessageMetaData;
import ch.squaredesk.nova.comm.http.RequestInfo;
import ch.squaredesk.nova.comm.http.RequestMessageMetaData;
import ch.squaredesk.nova.comm.http.RpcReply;
import ch.squaredesk.nova.metrics.Metrics;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RpcClient
extends ch.squaredesk.nova.comm.rpc.RpcClient<String, RequestMessageMetaData, ReplyMessageMetaData> {
    private final AsyncHttpClient client;
    private Map<String, String> standardHeadersForAllRequests;
    private boolean contentTypeInStandardHeaders;

    RpcClient(String identifier, AsyncHttpClient client, Metrics metrics) {
        super(identifier, metrics);
        this.client = client;
    }

    public <T, U> Single<RpcReply<U>> sendRequest(T request, RequestMessageMetaData requestMessageMetaData, Function<T, String> requestTranscriber, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        String requestAsString;
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        try {
            requestAsString = request != null ? (String)requestTranscriber.apply(request) : null;
        }
        catch (Exception e) {
            return Single.error((Throwable)e);
        }
        AsyncHttpClient.BoundRequestBuilder requestBuilder = ((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.POST ? this.client.preparePost(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : (((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.PUT ? this.client.preparePut(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : (((RequestInfo)requestMessageMetaData.details).requestMethod == HttpRequestMethod.DELETE ? this.client.prepareDelete(((URL)requestMessageMetaData.destination).toString()).setBody(requestAsString) : this.client.prepareGet(((URL)requestMessageMetaData.destination).toString())));
        RpcClient.addHeadersToRequest(this.standardHeadersForAllRequests, requestBuilder);
        RpcClient.addHeadersToRequest(((RequestInfo)requestMessageMetaData.details).headers, requestBuilder);
        if (!this.contentTypeInStandardHeaders && !RpcClient.headersContainContentType(((RequestInfo)requestMessageMetaData.details).headers)) {
            requestBuilder.addHeader("Content-Type", "application/json; charset=utf-8");
        }
        ListenableFuture resultFuture = requestBuilder.execute();
        Single resultSingle = Single.fromFuture((Future)resultFuture).map(response -> {
            ReplyMessageMetaData metaData = RpcClient.createMetaDataFromReply(requestMessageMetaData, response);
            String responseBody = response.getResponseBody();
            Object replyObject = responseBody == null || responseBody.trim().isEmpty() ? null : replyTranscriber.apply((Object)responseBody);
            this.metricsCollector.rpcCompleted(requestMessageMetaData.destination, (Object)responseBody);
            return new RpcReply<Object>(replyObject, metaData);
        });
        return resultSingle.timeout(timeout, timeUnit);
    }

    private static ReplyMessageMetaData createMetaDataFromReply(RequestMessageMetaData requestMessageMetaData, Response response) {
        Map<String, String> headersToReturn;
        FluentCaseInsensitiveStringsMap responseHeaders = response.getHeaders();
        if (responseHeaders.isEmpty()) {
            headersToReturn = Collections.emptyMap();
        } else {
            HashMap<String, String> headerMap = new HashMap<String, String>(responseHeaders.size() + 1, 1.0f);
            responseHeaders.forEach((key, valueList) -> headerMap.put((String)key, String.join((CharSequence)",", valueList)));
            headersToReturn = headerMap;
        }
        return new ReplyMessageMetaData((URL)requestMessageMetaData.destination, new ReplyInfo(response.getStatusCode(), headersToReturn));
    }

    void shutdown() {
        this.client.close();
    }

    public Map<String, String> getStandardHeadersForAllRequests() {
        return this.standardHeadersForAllRequests;
    }

    public void setStandardHeadersForAllRequests(Map<String, String> standardHeadersForAllRequests) {
        this.standardHeadersForAllRequests = standardHeadersForAllRequests;
        this.contentTypeInStandardHeaders = RpcClient.headersContainContentType(standardHeadersForAllRequests);
    }

    private static boolean headersContainContentType(Map<String, String> headersToCheck) {
        return headersToCheck != null && headersToCheck.containsKey("Content-Type");
    }

    private static void addHeadersToRequest(Map<String, String> headersToAdd, AsyncHttpClient.BoundRequestBuilder requestBuilder) {
        if (headersToAdd != null) {
            headersToAdd.entrySet().forEach(entry -> requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue()));
        }
    }
}

