/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.http;

import ch.squaredesk.nova.comm.CommAdapter;
import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.DefaultMessageTranscriberForStringAsTransportType;
import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.http.FrozenHttpAdapter;
import ch.squaredesk.nova.comm.http.HttpRequestMethod;
import ch.squaredesk.nova.comm.http.RequestInfo;
import ch.squaredesk.nova.comm.http.RequestMessageMetaData;
import ch.squaredesk.nova.comm.http.RpcClient;
import ch.squaredesk.nova.comm.http.RpcInvocation;
import ch.squaredesk.nova.comm.http.RpcReply;
import ch.squaredesk.nova.comm.http.RpcServer;
import com.ning.http.client.AsyncHttpClient;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.glassfish.grizzly.http.server.HttpServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpAdapter
extends CommAdapter<String> {
    private final RpcClient rpcClient;
    private final RpcServer rpcServer;
    private final Long defaultRequestTimeout;
    private final TimeUnit defaultRequestTimeUnit;

    private HttpAdapter(Builder builder) {
        super(builder.messageTranscriber, builder.metrics);
        this.rpcClient = builder.rpcClient;
        this.rpcServer = builder.rpcServer;
        this.defaultRequestTimeout = builder.defaultRequestTimeout;
        this.defaultRequestTimeUnit = builder.defaultRequestTimeUnit;
    }

    public <T> FrozenHttpAdapter<T> freeze(Class<T> typeClass) {
        return new FrozenHttpAdapter<T>(this, typeClass);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Class<U> replyType) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), replyType, null, null);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Map<String, String> headers, Class<U> replyType) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET, headers), replyType, null, null);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), replyType, (Long)timeout, timeUnit);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Map<String, String> headers, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET, headers), replyType, (Long)timeout, timeUnit);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), replyTranscriber, null, null);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Map<String, String> headers, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET, headers), replyTranscriber, null, null);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <U> Single<RpcReply<U>> sendGetRequest(String destination, Map<String, String> headers, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, null, new RequestInfo(HttpRequestMethod.GET, headers), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Map<String, String> headers, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST, headers), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Map<String, String> headers, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST, headers), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST, headers), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPostRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.POST, headers), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Map<String, String> headers, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT, headers), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Map<String, String> headers, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT, headers), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT, headers), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendPutRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.PUT, headers), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Map<String, String> headers, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE, headers), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Map<String, String> headers, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE, headers), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE, headers), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendDeleteRequest(String destination, T request, Map<String, String> headers, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(HttpRequestMethod.DELETE, headers), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Map<String, String> headers, Class<U> replyType) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod, headers), replyType, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Map<String, String> headers, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod, headers), replyType, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Map<String, String> headers, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod, headers), replyTranscriber, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, HttpRequestMethod requestMethod, Map<String, String> headers, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, new RequestInfo(requestMethod, headers), replyTranscriber, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, RequestInfo sendingInfo, Class<U> replyType, Long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, request, sendingInfo, this.messageTranscriber.getIncomingMessageTranscriber(replyType), timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(String destination, T request, RequestInfo httpInfo, Function<String, U> replyTranscriber, Long timeout, TimeUnit timeUnit) {
        URL url;
        if (timeout != null) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null if timeout specified");
        } else {
            timeout = this.defaultRequestTimeout;
            timeUnit = this.defaultRequestTimeUnit;
        }
        try {
            url = new URL(destination);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid URL format " + destination, e);
        }
        RequestMessageMetaData sendingInfo = new RequestMessageMetaData(url, httpInfo);
        return this.rpcClient.sendRequest(request, sendingInfo, this.messageTranscriber.getOutgoingMessageTranscriber(request), replyTranscriber, (long)timeout, timeUnit);
    }

    public <T> Flowable<RpcInvocation<T>> requests(String destination, Class<T> requestType) {
        return this.rpcServer.requests(destination, requestType);
    }

    public void start() throws Exception {
        this.rpcServer.start();
    }

    public void shutdown() {
        if (this.rpcServer != null) {
            this.rpcServer.shutdown();
        }
        this.rpcClient.shutdown();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CommAdapterBuilder<String, HttpAdapter> {
        private static Logger logger = LoggerFactory.getLogger(Builder.class);
        private String identifier;
        private HttpServer httpServer;
        private RpcClient rpcClient;
        private RpcServer rpcServer;
        private Long defaultRequestTimeout;
        private TimeUnit defaultRequestTimeUnit;

        private Builder() {
        }

        public Builder setDefaultRequestTimeout(long timeout, TimeUnit timeUnit) {
            Objects.requireNonNull(timeUnit);
            if (timeout > 0L) {
                this.defaultRequestTimeout = timeout;
                this.defaultRequestTimeUnit = timeUnit;
            }
            return this;
        }

        public Builder setHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public Builder setMessageTranscriber(MessageTranscriber<String> val) {
            super.setMessageTranscriber(val);
            return this;
        }

        public Builder setRpcServer(RpcServer rpcServer) {
            this.rpcServer = rpcServer;
            return this;
        }

        public Builder setRpcClient(RpcClient rpcClient) {
            this.rpcClient = rpcClient;
            return this;
        }

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        protected void validate() {
        }

        protected HttpAdapter createInstance() {
            this.validate();
            if (this.messageTranscriber == null) {
                this.messageTranscriber = new DefaultMessageTranscriberForStringAsTransportType();
            }
            if (this.defaultRequestTimeout == null) {
                this.defaultRequestTimeout = 15L;
                this.defaultRequestTimeUnit = TimeUnit.SECONDS;
            }
            if (this.rpcClient == null) {
                AsyncHttpClient httpClient = new AsyncHttpClient();
                this.rpcClient = new RpcClient(this.identifier, httpClient, this.metrics);
            }
            if (this.rpcServer == null) {
                if (this.httpServer == null) {
                    logger.info("No httpServer provided, HTTP Adapter will only be usable in client mode!!!");
                } else {
                    this.rpcServer = new RpcServer(this.identifier, this.httpServer, (MessageTranscriber<String>)this.messageTranscriber, this.metrics);
                }
            }
            return new HttpAdapter(this);
        }
    }
}

