/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.jms.DefaultDestinationIdGenerator;
import ch.squaredesk.nova.comm.jms.JmsMessageReceiver;
import ch.squaredesk.nova.comm.jms.JmsMessageSender;
import ch.squaredesk.nova.comm.jms.JmsObjectRepository;
import ch.squaredesk.nova.comm.jms.JmsRpcClient;
import ch.squaredesk.nova.comm.jms.JmsRpcInvocation;
import ch.squaredesk.nova.comm.jms.JmsRpcServer;
import ch.squaredesk.nova.comm.jms.JmsSessionDescriptor;
import ch.squaredesk.nova.comm.jms.JmsSpecificInfo;
import ch.squaredesk.nova.comm.jms.UIDCorrelationIdGenerator;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.schedulers.Schedulers;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAdapter<InternalMessageType> {
    private static final Logger logger = LoggerFactory.getLogger(JmsAdapter.class);
    static final Scheduler jmsSubscriptionScheduler = Schedulers.from((Executor)Executors.newSingleThreadExecutor(runnable -> {
        Thread t = new Thread(runnable, "JmsAdapter[Subscription]");
        t.setDaemon(true);
        return t;
    }));
    private final JmsMessageSender<InternalMessageType> messageSender;
    private final JmsMessageReceiver<InternalMessageType> messageReceiver;
    private final JmsRpcClient<InternalMessageType> rpcClient;
    private final JmsRpcServer<InternalMessageType> rpcServer;
    private final JmsObjectRepository jmsObjectRepository;
    private final int defaultMessagePriority;
    private final long defaultMessageTimeToLive;
    private final int defaultMessageDeliveryMode;
    private final ConcurrentLinkedDeque<Consumer<Destination>> destinationListeners = new ConcurrentLinkedDeque();
    private final Supplier<String> correlationIdGenerator;
    private final long defaultRpcTimeout;
    private final TimeUnit defaultRpcTimeUnit;

    protected JmsAdapter(Builder<InternalMessageType> builder) {
        this.messageReceiver = ((Builder)builder).messageReceiver;
        this.messageSender = ((Builder)builder).messageSender;
        this.rpcServer = ((Builder)builder).rpcServer;
        this.rpcClient = ((Builder)builder).rpcClient;
        this.correlationIdGenerator = ((Builder)builder).correlationIdGenerator;
        this.jmsObjectRepository = ((Builder)builder).jmsObjectRepository;
        this.defaultMessageDeliveryMode = ((Builder)builder).defaultDeliveryMode;
        this.defaultMessagePriority = ((Builder)builder).defaultPriority;
        this.defaultMessageTimeToLive = ((Builder)builder).defaultTimeToLive;
        this.defaultRpcTimeout = ((Builder)builder).defaultRpcTimeout;
        this.defaultRpcTimeUnit = ((Builder)builder).defaultRpcTimeUnit;
    }

    public <ConcreteMessageType extends InternalMessageType> Completable sendMessage(Destination destination, ConcreteMessageType message) {
        return this.doSendMessage(destination, message, null, null, null, null);
    }

    public <ConcreteMessageType extends InternalMessageType> Completable sendMessage(Destination destination, ConcreteMessageType message, Map<String, Object> customHeaders) {
        return this.doSendMessage(destination, message, customHeaders, null, null, null);
    }

    protected <ConcreteMessageType extends InternalMessageType> Completable doSendMessage(Destination destination, ConcreteMessageType message, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive) {
        Objects.requireNonNull(message, "message must not be null");
        JmsSpecificInfo jmsSpecificSendingInfo = new JmsSpecificInfo(null, null, customHeaders, deliveryMode == null ? this.defaultMessageDeliveryMode : deliveryMode, priority == null ? this.defaultMessagePriority : priority, timeToLive == null ? this.defaultMessageTimeToLive : timeToLive);
        return this.messageSender.sendMessage(destination, message, jmsSpecificSendingInfo).doOnError(t -> this.examineSendExceptionForDeadDestinationAndInformListener((Throwable)t, destination));
    }

    public Flowable<InternalMessageType> messages(Destination destination) {
        return this.messageReceiver.messages(destination).filter(incomingMessage -> !((JmsSpecificInfo)incomingMessage.details.transportSpecificDetails).isRpcReply()).map(incomingMessage -> incomingMessage.message);
    }

    public Flowable<JmsRpcInvocation<InternalMessageType>> requests(Destination destination) {
        Objects.requireNonNull(destination, "destination must not be null");
        return this.rpcServer.requests(destination);
    }

    private <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, Destination replyDestination, RequestType request, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive, Long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(replyDestination, "ReplyDestination must not be null");
        if (timeout != null) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null if timeout specified");
        } else {
            timeout = this.defaultRpcTimeout;
            timeUnit = this.defaultRpcTimeUnit;
        }
        int deliveryModeToUse = deliveryMode == null ? this.defaultMessageDeliveryMode : deliveryMode;
        int priorityToUse = priority == null ? this.defaultMessagePriority : priority;
        long timeToLiveToUse = timeToLive == null ? this.defaultMessageTimeToLive : timeToLive;
        timeToLiveToUse = Math.min(timeToLiveToUse, timeUnit.toMillis(timeout));
        String correlationId = this.correlationIdGenerator.get();
        JmsSpecificInfo jmsSpecificInfo = new JmsSpecificInfo(correlationId, replyDestination, customHeaders, deliveryModeToUse, priorityToUse, timeToLiveToUse);
        MessageSendingInfo sendingInfo = new MessageSendingInfo.Builder().withDestination((Object)destination).withTransportSpecificInfo((Object)jmsSpecificInfo).build();
        return this.rpcClient.sendRequest(request, (MessageSendingInfo<Destination, JmsSpecificInfo>)sendingInfo, timeout, timeUnit).doOnError(t -> this.examineSendExceptionForDeadDestinationAndInformListener((Throwable)t, destination));
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, Destination replyDestination, RequestType message, Map<String, Object> customHeaders, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, replyDestination, message, customHeaders, null, null, null, timeout, timeUnit);
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, RequestType message, Map<String, Object> customHeaders, Long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, null, null, null, timeout, timeUnit);
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, RequestType message, Map<String, Object> customHeaders) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, null, null, null, null, null);
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, RequestType message, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, null, null, null, timeout, timeUnit);
    }

    public <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Single<ReplyType> sendRequest(Destination destination, RequestType message) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, null, null, null, null, null);
    }

    public void addDestinationListener(Consumer<Destination> destinationListener) {
        this.destinationListeners.add(destinationListener);
    }

    public void removeDestinationListener(Consumer<Destination> destinationListener) {
        this.destinationListeners.remove(destinationListener);
    }

    private void notifyDestinationListenersAboutDeadDestination(Destination deadDestination) {
        this.destinationListeners.forEach((Consumer<Consumer<Destination>>)((Consumer<Consumer>)consumer -> {
            try {
                consumer.accept(deadDestination);
            }
            catch (Throwable t) {
                logger.error("An error occurred trying to inform listener about dead destination " + deadDestination, t);
            }
        }));
    }

    private void examineSendExceptionForDeadDestinationAndInformListener(Throwable error, Destination destination) {
        if (JmsAdapter.exceptionSignalsDestinationDown(error)) {
            this.notifyDestinationListenersAboutDeadDestination(destination);
        }
    }

    private static boolean exceptionSignalsDestinationDown(Throwable errorToExamine) {
        Throwable error;
        Function<Throwable, Boolean> testFunc = ex -> ex instanceof InvalidDestinationException || String.valueOf(ex).contains("does not exist");
        boolean down = testFunc.apply(error);
        for (error = errorToExamine; !down && error != null && error.getCause() != null && error.getCause() != error; error = error.getCause()) {
            down = testFunc.apply(error);
        }
        return down;
    }

    public void shutdown() {
        this.jmsObjectRepository.shutdown();
    }

    public void start() throws JMSException {
        this.jmsObjectRepository.start();
    }

    public static <InternalMessageType> Builder<InternalMessageType> builder(Class<InternalMessageType> messageTypeClass) {
        return new Builder(messageTypeClass);
    }

    public static class Builder<InternalMessageType>
    extends CommAdapterBuilder<InternalMessageType, JmsAdapter<InternalMessageType>> {
        private String identifier;
        private Supplier<String> correlationIdGenerator;
        private Function<Throwable, InternalMessageType> errorReplyFactory;
        private Function<Destination, String> destinationIdGenerator;
        private ConnectionFactory connectionFactory;
        private boolean consumerSessionTransacted = false;
        private int consumerSessionAckMode = 1;
        private boolean producerSessionTransacted = false;
        private int producerSessionAckMode = 1;
        private int defaultPriority = 4;
        private long defaultTimeToLive = 0L;
        private int defaultDeliveryMode = 1;
        private JmsObjectRepository jmsObjectRepository;
        private JmsMessageSender<InternalMessageType> messageSender;
        private JmsMessageReceiver<InternalMessageType> messageReceiver;
        private JmsRpcServer<InternalMessageType> rpcServer;
        private JmsRpcClient<InternalMessageType> rpcClient;
        private long defaultRpcTimeout;
        private TimeUnit defaultRpcTimeUnit;

        private Builder(Class<InternalMessageType> messageTypeClass) {
            super(messageTypeClass);
        }

        public Builder<InternalMessageType> setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder<InternalMessageType> setDefaultRpcTimeout(long defaultRpcTimeout, TimeUnit timeUnit) {
            this.defaultRpcTimeout = defaultRpcTimeout;
            this.defaultRpcTimeUnit = timeUnit;
            return this;
        }

        public Builder<InternalMessageType> setDefaultMessagePriority(int priority) {
            this.defaultPriority = priority;
            return this;
        }

        public Builder<InternalMessageType> setDefaultMessageTimeToLive(long timeToLive) {
            this.defaultTimeToLive = timeToLive;
            return this;
        }

        public Builder<InternalMessageType> setDefaultMessageDeliveryMode(int deliveryMode) {
            this.defaultDeliveryMode = deliveryMode;
            return this;
        }

        public Builder<InternalMessageType> setConnectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder<InternalMessageType> setProducerSessionTransacted(boolean sessionTransacted) {
            this.producerSessionTransacted = sessionTransacted;
            return this;
        }

        public Builder<InternalMessageType> setProducerSessionAckMode(int sessionAckMode) {
            this.producerSessionAckMode = sessionAckMode;
            return this;
        }

        public Builder<InternalMessageType> setConsumerSessionTransacted(boolean sessionTransacted) {
            this.consumerSessionTransacted = sessionTransacted;
            return this;
        }

        public Builder<InternalMessageType> setConsumerSessionAckMode(int sessionAckMode) {
            this.consumerSessionAckMode = sessionAckMode;
            return this;
        }

        public Builder<InternalMessageType> setCorrelationIdGenerator(Supplier<String> correlationIdGenerator) {
            this.correlationIdGenerator = correlationIdGenerator;
            return this;
        }

        public Builder<InternalMessageType> setDestinationIdGenerator(Function<Destination, String> destinationIdGenerator) {
            this.destinationIdGenerator = destinationIdGenerator;
            return this;
        }

        public Builder<InternalMessageType> setErrorReplyFactory(Function<Throwable, InternalMessageType> errorReplyFactory) {
            this.errorReplyFactory = errorReplyFactory;
            return this;
        }

        public Builder<InternalMessageType> setRpcClient(JmsRpcClient<InternalMessageType> rpcClient) {
            this.rpcClient = rpcClient;
            return this;
        }

        protected void validate() {
            Objects.requireNonNull(this.metrics, "metrics must be provided");
            Objects.requireNonNull(this.messageUnmarshaller, "messageUnmarshaller must be provided");
            Objects.requireNonNull(this.messageMarshaller, "messageMarshaller must be provided");
            Objects.requireNonNull(this.errorReplyFactory, "errorReplyFactory must be provided");
            Objects.requireNonNull(this.connectionFactory, "connectionFactory must be provided");
            if (this.correlationIdGenerator == null) {
                this.correlationIdGenerator = new UIDCorrelationIdGenerator();
            }
            if (this.destinationIdGenerator == null) {
                this.destinationIdGenerator = new DefaultDestinationIdGenerator();
            }
            if (this.defaultRpcTimeout <= 0L || this.defaultRpcTimeUnit == null) {
                this.defaultRpcTimeout = 30L;
                this.defaultRpcTimeUnit = TimeUnit.SECONDS;
            }
        }

        public JmsAdapter<InternalMessageType> createInstance() {
            Connection connection;
            try {
                logger.debug("Creating connection to broker...");
                connection = this.connectionFactory.createConnection();
            }
            catch (JMSException e) {
                throw new RuntimeException("Unable to create JMS session", e);
            }
            logger.debug("Creating JmsObjectRepository...");
            JmsSessionDescriptor producerSessionDescriptor = new JmsSessionDescriptor(this.producerSessionTransacted, this.producerSessionAckMode);
            JmsSessionDescriptor consumerSessionDescriptor = new JmsSessionDescriptor(this.consumerSessionTransacted, this.consumerSessionAckMode);
            this.jmsObjectRepository = new JmsObjectRepository(connection, producerSessionDescriptor, consumerSessionDescriptor, this.destinationIdGenerator);
            this.messageReceiver = new JmsMessageReceiver(this.identifier, this.jmsObjectRepository, this.messageUnmarshaller, this.metrics);
            this.messageSender = new JmsMessageSender(this.identifier, this.jmsObjectRepository, this.messageMarshaller, this.metrics);
            this.rpcServer = new JmsRpcServer<InternalMessageType>(this.identifier, this.messageReceiver, this.messageSender, this.errorReplyFactory, this.metrics);
            if (this.rpcClient == null) {
                this.rpcClient = new JmsRpcClient<InternalMessageType>(this.identifier, this.messageReceiver, this.messageSender, this.metrics);
            }
            return new JmsAdapter(this);
        }
    }
}

