/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.JmsAdapter;
import ch.squaredesk.nova.comm.jms.JmsObjectRepository;
import ch.squaredesk.nova.comm.jms.JmsSpecificInfo;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.sending.MessageSender;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Completable;
import java.util.Objects;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;

class JmsMessageSender<InternalMessageType>
extends MessageSender<Destination, InternalMessageType, String, JmsSpecificInfo> {
    private final JmsObjectRepository jmsObjectRepository;

    JmsMessageSender(String identifier, JmsObjectRepository jmsObjectRepository, MessageMarshaller<InternalMessageType, String> messageMarshaller, Metrics metrics) {
        super(identifier, messageMarshaller, metrics);
        this.jmsObjectRepository = jmsObjectRepository;
    }

    public Completable doSend(String message, MessageSendingInfo<Destination, JmsSpecificInfo> sendingInfo) {
        Objects.requireNonNull(message, "message must not be null");
        return Completable.create(s -> {
            try {
                TextMessage textMessage = this.jmsObjectRepository.createTextMessage();
                if (sendingInfo.transportSpecificInfo != null) {
                    textMessage.setJMSCorrelationID(((JmsSpecificInfo)sendingInfo.transportSpecificInfo).correlationId);
                    textMessage.setJMSReplyTo(((JmsSpecificInfo)sendingInfo.transportSpecificInfo).replyDestination);
                    if (((JmsSpecificInfo)sendingInfo.transportSpecificInfo).customHeaders != null) {
                        for (String key : ((JmsSpecificInfo)sendingInfo.transportSpecificInfo).customHeaders.keySet()) {
                            textMessage.setObjectProperty(key, ((JmsSpecificInfo)sendingInfo.transportSpecificInfo).customHeaders.get(key));
                        }
                    }
                }
                textMessage.setText(message);
                MessageProducer producer = this.jmsObjectRepository.createMessageProducer((Destination)sendingInfo.destination);
                producer.send((Message)textMessage, ((JmsSpecificInfo)sendingInfo.transportSpecificInfo).deliveryMode.intValue(), ((JmsSpecificInfo)sendingInfo.transportSpecificInfo).priority.intValue(), ((JmsSpecificInfo)sendingInfo.transportSpecificInfo).timeToLive.longValue());
                s.onComplete();
            }
            catch (Throwable t) {
                s.onError(t);
            }
        }).subscribeOn(JmsAdapter.jmsSubscriptionScheduler);
    }
}

