/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.JmsMessageReceiver;
import ch.squaredesk.nova.comm.jms.JmsMessageSender;
import ch.squaredesk.nova.comm.jms.JmsRpcInvocation;
import ch.squaredesk.nova.comm.jms.JmsSpecificInfo;
import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.rpc.RpcServer;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Flowable;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.jms.Destination;

public class JmsRpcServer<InternalMessageType>
extends RpcServer<Destination, JmsRpcInvocation<InternalMessageType>> {
    private final JmsMessageSender<InternalMessageType> messageSender;
    private final JmsMessageReceiver<InternalMessageType> messageReceiver;
    private final Function<Throwable, InternalMessageType> errorReplyFactory;

    JmsRpcServer(String identifier, JmsMessageReceiver<InternalMessageType> messageReceiver, JmsMessageSender<InternalMessageType> messageSender, Function<Throwable, InternalMessageType> errorReplyFactory, Metrics metrics) {
        super(identifier, metrics);
        Objects.requireNonNull(messageSender, "messageSender must not be null");
        Objects.requireNonNull(messageReceiver, "messageReceiver must not be null");
        Objects.requireNonNull(errorReplyFactory, "errorReplyFactory must not be null");
        this.messageSender = messageSender;
        this.messageReceiver = messageReceiver;
        this.errorReplyFactory = errorReplyFactory;
    }

    public Flowable<JmsRpcInvocation<InternalMessageType>> requests(Destination destination) {
        return this.messageReceiver.messages(destination).filter(this::isRpcRequest).map(incomingMessage -> {
            this.metricsCollector.requestReceived(incomingMessage.message);
            Object request = incomingMessage.message;
            Consumer replyConsumer = this.createReplyHandlerFor((IncomingMessage)incomingMessage);
            Consumer<Throwable> errorConsumer = this.createErrorReplyHandlerFor((IncomingMessage<InternalMessageType, Destination, JmsSpecificInfo>)incomingMessage);
            return new JmsRpcInvocation<Object>(request, (JmsSpecificInfo)incomingMessage.details.transportSpecificDetails, reply -> {
                replyConsumer.accept(reply._1);
                this.metricsCollector.requestCompleted(incomingMessage.message, reply);
            }, error -> {
                this.metricsCollector.requestCompletedExceptionally(incomingMessage.message, error);
                errorConsumer.accept((Throwable)error);
            });
        });
    }

    private boolean isRpcRequest(IncomingMessage<InternalMessageType, Destination, JmsSpecificInfo> incomingMessage) {
        return incomingMessage.details != null && incomingMessage.details.transportSpecificDetails != null && ((JmsSpecificInfo)incomingMessage.details.transportSpecificDetails).replyDestination != null && ((JmsSpecificInfo)incomingMessage.details.transportSpecificDetails).correlationId != null;
    }

    private <RequestType extends InternalMessageType, ReplyType extends InternalMessageType> Consumer<ReplyType> createReplyHandlerFor(IncomingMessage<RequestType, Destination, JmsSpecificInfo> request) {
        JmsSpecificInfo sendingInfo = new JmsSpecificInfo(((JmsSpecificInfo)request.details.transportSpecificDetails).correlationId, null, null, null, null, null);
        return reply -> this.messageSender.sendMessage(((JmsSpecificInfo)request.details.transportSpecificDetails).replyDestination, reply, sendingInfo);
    }

    private Consumer<Throwable> createErrorReplyHandlerFor(IncomingMessage<InternalMessageType, Destination, JmsSpecificInfo> request) {
        JmsSpecificInfo sendingInfo = new JmsSpecificInfo(((JmsSpecificInfo)request.details.transportSpecificDetails).correlationId, null, null, null, null, null);
        return error -> this.messageSender.sendMessage(((JmsSpecificInfo)request.details.transportSpecificDetails).replyDestination, this.errorReplyFactory.apply((Throwable)error), sendingInfo);
    }
}

