/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.JmsSpecificInfo;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

class JmsSpecificInfoExtractor {
    private JmsSpecificInfoExtractor() {
    }

    static JmsSpecificInfo extractFrom(Message message) throws JMSException {
        Destination replyTo = message.getJMSReplyTo();
        String correlationId = message.getJMSCorrelationID();
        int deliveryMode = message.getJMSDeliveryMode();
        int priority = message.getJMSPriority();
        long timeToLive = message.getJMSExpiration();
        HashMap<String, Object> customHeaders = null;
        Enumeration enumeration = message.getPropertyNames();
        if (enumeration.hasMoreElements()) {
            customHeaders = new HashMap<String, Object>(3, 1.0f);
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                customHeaders.put(key, String.valueOf(message.getObjectProperty(key)));
            }
        }
        return new JmsSpecificInfo(correlationId, replyTo, customHeaders, deliveryMode, priority, timeToLive);
    }
}

