/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.RetrieveInfo;
import java.util.Enumeration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

class JmsSpecificInfoExtractor {
    private JmsSpecificInfoExtractor() {
    }

    static RetrieveInfo extractFrom(Message message) throws JMSException {
        Destination replyTo = message.getJMSReplyTo();
        String correlationId = message.getJMSCorrelationID();
        HashMap<String, Object> customHeaders = null;
        Enumeration enumeration = message.getPropertyNames();
        if (enumeration.hasMoreElements()) {
            customHeaders = new HashMap<String, Object>(3, 1.0f);
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                customHeaders.put(key, String.valueOf(message.getObjectProperty(key)));
            }
        }
        return new RetrieveInfo(correlationId, replyTo, customHeaders);
    }
}

