/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.jms.OutgoingMessageMetaData;
import ch.squaredesk.nova.comm.jms.RetrieveInfo;
import ch.squaredesk.nova.comm.jms.RpcReply;
import ch.squaredesk.nova.comm.jms.SendInfo;
import ch.squaredesk.nova.comm.retrieving.MessageReceiver;
import ch.squaredesk.nova.comm.sending.MessageSender;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Single;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.Destination;

public class RpcClient<InternalMessageType>
extends ch.squaredesk.nova.comm.rpc.RpcClient<InternalMessageType, OutgoingMessageMetaData, IncomingMessageMetaData> {
    private final MessageSender<InternalMessageType, OutgoingMessageMetaData> messageSender;
    private final MessageReceiver<Destination, InternalMessageType, IncomingMessageMetaData> messageReceiver;

    public RpcClient(String identifier, MessageSender<InternalMessageType, OutgoingMessageMetaData> messageSender, MessageReceiver<Destination, InternalMessageType, IncomingMessageMetaData> messageReceiver, Metrics metrics) {
        super(identifier, metrics);
        this.messageSender = messageSender;
        this.messageReceiver = messageReceiver;
    }

    public <ReplyType extends InternalMessageType> Single<RpcReply<ReplyType>> sendRequest(InternalMessageType request, OutgoingMessageMetaData outgoingMessageMetaData, long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        Objects.requireNonNull(outgoingMessageMetaData, "metaData must not be null");
        Objects.requireNonNull(outgoingMessageMetaData.details, "metaData.details must not be null");
        Objects.requireNonNull(((SendInfo)outgoingMessageMetaData.details).correlationId, "correlationId must not be null");
        Objects.requireNonNull(((SendInfo)outgoingMessageMetaData.details).replyDestination, "replyDestination must not be null");
        Single replySingle = this.messageReceiver.messages((Object)((SendInfo)outgoingMessageMetaData.details).replyDestination).filter(incomingMessage -> ((IncomingMessageMetaData)incomingMessage.metaData).details != null && ((SendInfo)outgoingMessageMetaData.details).correlationId.equals(((RetrieveInfo)((IncomingMessageMetaData)incomingMessage.metaData).details).correlationId)).take(1L).doOnNext(reply -> this.metricsCollector.rpcCompleted(request, reply)).map(incomingMessage -> new RpcReply<Object>(incomingMessage.message, (IncomingMessageMetaData)incomingMessage.metaData)).singleOrError();
        Throwable sendError = this.messageSender.doSend(request, (Object)outgoingMessageMetaData).blockingGet();
        if (sendError != null) {
            return Single.error((Throwable)sendError);
        }
        return replySingle.timeout(timeout, timeUnit).doOnError(t -> {
            if (t instanceof TimeoutException) {
                this.metricsCollector.rpcTimedOut(request);
            }
        });
    }
}

