/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.CommAdapter;
import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.DefaultMessageTranscriberForStringAsTransportType;
import ch.squaredesk.nova.comm.jms.DefaultDestinationIdGenerator;
import ch.squaredesk.nova.comm.jms.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.jms.JmsObjectRepository;
import ch.squaredesk.nova.comm.jms.JmsSessionDescriptor;
import ch.squaredesk.nova.comm.jms.MessageReceiver;
import ch.squaredesk.nova.comm.jms.MessageSender;
import ch.squaredesk.nova.comm.jms.OutgoingMessageMetaData;
import ch.squaredesk.nova.comm.jms.RetrieveInfo;
import ch.squaredesk.nova.comm.jms.RpcClient;
import ch.squaredesk.nova.comm.jms.RpcInvocation;
import ch.squaredesk.nova.comm.jms.RpcReply;
import ch.squaredesk.nova.comm.jms.RpcServer;
import ch.squaredesk.nova.comm.jms.SendInfo;
import ch.squaredesk.nova.comm.jms.UIDCorrelationIdGenerator;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAdapter
extends CommAdapter<String> {
    private static final Logger logger = LoggerFactory.getLogger(JmsAdapter.class);
    private final MessageSender messageSender;
    private final MessageReceiver messageReceiver;
    private final RpcClient rpcClient;
    private final RpcServer rpcServer;
    private final JmsObjectRepository jmsObjectRepository;
    private final int defaultMessagePriority;
    private final long defaultMessageTimeToLive;
    private final int defaultMessageDeliveryMode;
    private final ConcurrentLinkedDeque<Consumer<Destination>> destinationListeners = new ConcurrentLinkedDeque();
    private final Supplier<String> correlationIdGenerator;
    private final long defaultRpcTimeout;
    private final TimeUnit defaultRpcTimeUnit;

    JmsAdapter(Builder builder) {
        super(builder.messageTranscriber, builder.metrics);
        this.messageReceiver = builder.messageReceiver;
        this.messageSender = builder.messageSender;
        this.rpcServer = builder.rpcServer;
        this.rpcClient = builder.rpcClient;
        this.correlationIdGenerator = builder.correlationIdGenerator;
        this.jmsObjectRepository = builder.jmsObjectRepository;
        this.defaultMessageDeliveryMode = builder.defaultDeliveryMode;
        this.defaultMessagePriority = builder.defaultPriority;
        this.defaultMessageTimeToLive = builder.defaultTimeToLive;
        this.defaultRpcTimeout = builder.defaultRpcTimeout;
        this.defaultRpcTimeUnit = builder.defaultRpcTimeUnit;
    }

    public <T> Completable sendMessage(Destination destination, T message) throws Exception {
        return this.sendMessage(destination, message, null, null, null, null);
    }

    public <T> Completable sendMessage(Destination destination, T message, Map<String, Object> customHeaders) {
        return this.sendMessage(destination, message, customHeaders, null, null, null);
    }

    public <T> Completable sendMessage(Destination destination, T message, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive) {
        Function transcriber = this.messageTranscriber.getOutgoingMessageTranscriber(message.getClass());
        return this.doSendMessage(destination, message, transcriber, customHeaders, deliveryMode, priority, timeToLive);
    }

    public <T> Completable sendMessage(Destination destination, T message, Function<T, String> transcriber) throws Exception {
        return this.doSendMessage(destination, message, transcriber, null, null, null, null);
    }

    public <T> Completable sendMessage(Destination destination, T message, Function<T, String> transcriber, Map<String, Object> customHeaders) {
        return this.doSendMessage(destination, message, transcriber, customHeaders, null, null, null);
    }

    public <T> Completable sendMessage(Destination destination, T message, Function<T, String> transcriber, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive) {
        return this.doSendMessage(destination, message, transcriber, customHeaders, deliveryMode, priority, timeToLive);
    }

    protected <T> Completable doSendMessage(Destination destination, T message, Function<T, String> transcriber, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive) {
        Objects.requireNonNull(message, "message must not be null");
        SendInfo jmsSpecificSendingInfo = new SendInfo(null, null, customHeaders, deliveryMode == null ? this.defaultMessageDeliveryMode : deliveryMode, priority == null ? this.defaultMessagePriority : priority, timeToLive == null ? this.defaultMessageTimeToLive : timeToLive);
        OutgoingMessageMetaData meta = new OutgoingMessageMetaData(destination, jmsSpecificSendingInfo);
        return this.messageSender.send(message, meta, transcriber).doOnError(t -> this.examineSendExceptionForDeadDestinationAndInformListener((Throwable)t, destination));
    }

    public Completable sendMessage(Destination destination, String message) {
        return this.doSendMessage(destination, message, null, null, null, null);
    }

    public Completable sendMessage(Destination destination, String message, Map<String, Object> customHeaders) {
        return this.doSendMessage(destination, message, customHeaders, null, null, null);
    }

    protected Completable doSendMessage(Destination destination, String message, Map<String, Object> customHeaders, Integer deliveryMode, Integer priority, Long timeToLive) {
        Objects.requireNonNull(message, "message must not be null");
        SendInfo jmsSpecificSendingInfo = new SendInfo(null, null, customHeaders, deliveryMode == null ? this.defaultMessageDeliveryMode : deliveryMode, priority == null ? this.defaultMessagePriority : priority, timeToLive == null ? this.defaultMessageTimeToLive : timeToLive);
        OutgoingMessageMetaData meta = new OutgoingMessageMetaData(destination, jmsSpecificSendingInfo);
        return this.messageSender.send(message, meta).doOnError(t -> this.examineSendExceptionForDeadDestinationAndInformListener((Throwable)t, destination));
    }

    public Flowable<String> messages(Destination destination) {
        return this.messageReceiver.messages(destination).filter(incomingMessage -> !((RetrieveInfo)((IncomingMessageMetaData)incomingMessage.metaData).details).isRpcReply()).map(incomingMessage -> (String)incomingMessage.message);
    }

    public <T> Flowable<T> messages(Destination destination, Class<T> messageType) {
        return this.messages(destination, this.messageTranscriber.getIncomingMessageTranscriber(messageType));
    }

    public <T> Flowable<T> messages(Destination destination, Function<String, T> messageTranscriber) {
        return this.messageReceiver.messages(destination, messageTranscriber).map(incomingMessage -> incomingMessage.message);
    }

    public <T> Flowable<RpcInvocation<T>> requests(Destination destination, Class<T> requestType) {
        Objects.requireNonNull(destination, "destination must not be null");
        return this.rpcServer.requests(destination, requestType);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, Destination replyDestination, T request, Map<String, Object> customHeaders, Function<String, U> replyTranscriber, Integer deliveryMode, Integer priority, Long timeToLive, Long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(replyDestination, "ReplyDestination must not be null");
        if (timeout != null) {
            Objects.requireNonNull(timeUnit, "timeUnit must not be null if timeout specified");
        } else {
            timeout = this.defaultRpcTimeout;
            timeUnit = this.defaultRpcTimeUnit;
        }
        int deliveryModeToUse = deliveryMode == null ? this.defaultMessageDeliveryMode : deliveryMode;
        int priorityToUse = priority == null ? this.defaultMessagePriority : priority;
        long timeToLiveToUse = timeToLive == null ? this.defaultMessageTimeToLive : timeToLive;
        timeToLiveToUse = Math.min(timeToLiveToUse, timeUnit.toMillis(timeout));
        String correlationId = this.correlationIdGenerator.get();
        SendInfo jmsSpecificInfo = new SendInfo(correlationId, replyDestination, customHeaders, deliveryModeToUse, priorityToUse, timeToLiveToUse);
        OutgoingMessageMetaData sendingInfo = new OutgoingMessageMetaData(destination, jmsSpecificInfo);
        return this.rpcClient.sendRequest(request, sendingInfo, this.messageTranscriber.getOutgoingMessageTranscriber(request), replyTranscriber, (long)timeout, timeUnit).doOnError(t -> this.examineSendExceptionForDeadDestinationAndInformListener((Throwable)t, destination));
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, Destination replyDestination, T message, Map<String, Object> customHeaders, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, replyDestination, message, customHeaders, replyTranscriber, null, null, null, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Map<String, Object> customHeaders, Function<String, U> replyTranscriber, Long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, replyTranscriber, null, null, null, timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Map<String, Object> customHeaders, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, replyTranscriber, null, null, null, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Function<String, U> replyTranscriber, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, replyTranscriber, null, null, null, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Function<String, U> replyTranscriber) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, replyTranscriber, null, null, null, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, Destination replyDestination, T request, Map<String, Object> customHeaders, Class<U> replyType, Integer deliveryMode, Integer priority, Long timeToLive, Long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, replyDestination, request, customHeaders, this.messageTranscriber.getIncomingMessageTranscriber(replyType), deliveryMode, priority, timeToLive, timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, Destination replyDestination, T message, Map<String, Object> customHeaders, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, replyDestination, message, customHeaders, this.messageTranscriber.getIncomingMessageTranscriber(replyType), null, null, null, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Map<String, Object> customHeaders, Class<U> replyType, Long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, this.messageTranscriber.getIncomingMessageTranscriber(replyType), null, null, null, timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Map<String, Object> customHeaders, Class<U> replyType) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, customHeaders, this.messageTranscriber.getIncomingMessageTranscriber(replyType), null, null, null, null, null);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Class<U> replyType, long timeout, TimeUnit timeUnit) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, this.messageTranscriber.getIncomingMessageTranscriber(replyType), null, null, null, (Long)timeout, timeUnit);
    }

    public <T, U> Single<RpcReply<U>> sendRequest(Destination destination, T message, Class<U> replyType) {
        return this.sendRequest(destination, this.jmsObjectRepository.getPrivateTempQueue(), message, null, this.messageTranscriber.getIncomingMessageTranscriber(replyType), null, null, null, null, null);
    }

    public void addDestinationListener(Consumer<Destination> destinationListener) {
        this.destinationListeners.add(destinationListener);
    }

    public void removeDestinationListener(Consumer<Destination> destinationListener) {
        this.destinationListeners.remove(destinationListener);
    }

    private void notifyDestinationListenersAboutDeadDestination(Destination deadDestination) {
        this.destinationListeners.forEach((Consumer<Consumer<Destination>>)((Consumer<Consumer>)consumer -> {
            try {
                consumer.accept(deadDestination);
            }
            catch (Exception e) {
                logger.error("An error occurred trying to inform listener about dead destination {}", (Object)deadDestination, (Object)e);
            }
        }));
    }

    private void examineSendExceptionForDeadDestinationAndInformListener(Throwable error, Destination destination) {
        if (JmsAdapter.exceptionSignalsDestinationDown(error)) {
            this.notifyDestinationListenersAboutDeadDestination(destination);
        }
    }

    private static boolean exceptionSignalsDestinationDown(Throwable errorToExamine) {
        Throwable error;
        java.util.function.Function<Throwable, Boolean> testFunc = ex -> ex instanceof InvalidDestinationException || String.valueOf(ex).contains("does not exist");
        boolean down = testFunc.apply(error);
        for (error = errorToExamine; !down && error != null && error.getCause() != null && error.getCause() != error; error = error.getCause()) {
            down = testFunc.apply(error);
        }
        return down;
    }

    public void shutdown() {
        this.jmsObjectRepository.shutdown();
    }

    public void start() throws JMSException {
        this.jmsObjectRepository.start();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CommAdapterBuilder<String, JmsAdapter> {
        private String identifier;
        private Supplier<String> correlationIdGenerator;
        private java.util.function.Function<Destination, String> destinationIdGenerator;
        private ConnectionFactory connectionFactory;
        private boolean consumerSessionTransacted = false;
        private int consumerSessionAckMode = 1;
        private boolean producerSessionTransacted = false;
        private int producerSessionAckMode = 1;
        private int defaultPriority = 4;
        private long defaultTimeToLive = 0L;
        private int defaultDeliveryMode = 1;
        private JmsObjectRepository jmsObjectRepository;
        private MessageSender messageSender;
        private MessageReceiver messageReceiver;
        private RpcServer rpcServer;
        private RpcClient rpcClient;
        private long defaultRpcTimeout;
        private TimeUnit defaultRpcTimeUnit;

        private Builder() {
        }

        public Builder setIdentifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder setDefaultRpcTimeout(long defaultRpcTimeout, TimeUnit timeUnit) {
            this.defaultRpcTimeout = defaultRpcTimeout;
            this.defaultRpcTimeUnit = timeUnit;
            return this;
        }

        public Builder setDefaultMessagePriority(int priority) {
            this.defaultPriority = priority;
            return this;
        }

        public Builder setDefaultMessageTimeToLive(long timeToLive) {
            this.defaultTimeToLive = timeToLive;
            return this;
        }

        public Builder setDefaultMessageDeliveryMode(int deliveryMode) {
            this.defaultDeliveryMode = deliveryMode;
            return this;
        }

        public Builder setConnectionFactory(ConnectionFactory connectionFactory) {
            this.connectionFactory = connectionFactory;
            return this;
        }

        public Builder setProducerSessionTransacted(boolean sessionTransacted) {
            this.producerSessionTransacted = sessionTransacted;
            return this;
        }

        public Builder setProducerSessionAckMode(int sessionAckMode) {
            this.producerSessionAckMode = sessionAckMode;
            return this;
        }

        public Builder setConsumerSessionTransacted(boolean sessionTransacted) {
            this.consumerSessionTransacted = sessionTransacted;
            return this;
        }

        public Builder setConsumerSessionAckMode(int sessionAckMode) {
            this.consumerSessionAckMode = sessionAckMode;
            return this;
        }

        public Builder setCorrelationIdGenerator(Supplier<String> correlationIdGenerator) {
            this.correlationIdGenerator = correlationIdGenerator;
            return this;
        }

        public Builder setDestinationIdGenerator(java.util.function.Function<Destination, String> destinationIdGenerator) {
            this.destinationIdGenerator = destinationIdGenerator;
            return this;
        }

        public Builder setJmsObjectRepository(JmsObjectRepository jmsObjectRepository) {
            this.jmsObjectRepository = jmsObjectRepository;
            return this;
        }

        public Builder setRpcClient(RpcClient rpcClient) {
            this.rpcClient = rpcClient;
            return this;
        }

        public Builder setRpcServer(RpcServer rpcServer) {
            this.rpcServer = rpcServer;
            return this;
        }

        public Builder setMessageReceiver(MessageReceiver messageReceiver) {
            this.messageReceiver = messageReceiver;
            return this;
        }

        public Builder setMessageSender(MessageSender messageSender) {
            this.messageSender = messageSender;
            return this;
        }

        protected void validate() {
            Objects.requireNonNull(this.metrics, "metrics must be provided");
            if (this.messageTranscriber == null) {
                this.messageTranscriber = new DefaultMessageTranscriberForStringAsTransportType();
            }
            if (this.messageSender == null || this.messageReceiver == null) {
                Objects.requireNonNull(this.connectionFactory, "connectionFactory must be provided");
            }
            if (this.correlationIdGenerator == null) {
                this.correlationIdGenerator = new UIDCorrelationIdGenerator();
            }
            if (this.destinationIdGenerator == null) {
                this.destinationIdGenerator = new DefaultDestinationIdGenerator();
            }
            if (this.defaultRpcTimeout <= 0L || this.defaultRpcTimeUnit == null) {
                this.defaultRpcTimeout = 30L;
                this.defaultRpcTimeUnit = TimeUnit.SECONDS;
            }
        }

        public JmsAdapter createInstance() {
            if (this.messageSender == null || this.messageReceiver == null) {
                Connection connection;
                try {
                    logger.debug("Creating connection to broker...");
                    connection = this.connectionFactory.createConnection();
                }
                catch (JMSException e) {
                    throw new RuntimeException("Unable to create JMS session", e);
                }
                logger.debug("Creating JmsObjectRepository...");
                JmsSessionDescriptor producerSessionDescriptor = new JmsSessionDescriptor(this.producerSessionTransacted, this.producerSessionAckMode);
                JmsSessionDescriptor consumerSessionDescriptor = new JmsSessionDescriptor(this.consumerSessionTransacted, this.consumerSessionAckMode);
                this.jmsObjectRepository = new JmsObjectRepository(connection, producerSessionDescriptor, consumerSessionDescriptor, this.destinationIdGenerator);
            }
            if (this.messageSender == null) {
                this.messageSender = new MessageSender(this.identifier, this.jmsObjectRepository, this.metrics);
            }
            if (this.messageReceiver == null) {
                this.messageReceiver = new MessageReceiver(this.identifier, this.jmsObjectRepository, this.metrics);
            }
            if (this.rpcServer == null) {
                this.rpcServer = new RpcServer(this.identifier, this.messageReceiver, this.messageSender, this.metrics);
            }
            if (this.rpcClient == null) {
                this.rpcClient = new RpcClient(this.identifier, this.messageSender, this.messageReceiver, this.metrics);
            }
            return new JmsAdapter(this);
        }
    }
}

