/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.JmsObjectRepository;
import ch.squaredesk.nova.comm.jms.OutgoingMessageMetaData;
import ch.squaredesk.nova.comm.jms.SendInfo;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Completable;
import java.util.Objects;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.TextMessage;

public class MessageSender
extends ch.squaredesk.nova.comm.sending.MessageSender<Destination, String, OutgoingMessageMetaData> {
    private final JmsObjectRepository jmsObjectRepository;

    MessageSender(String identifier, JmsObjectRepository jmsObjectRepository, Metrics metrics) {
        super(identifier, metrics);
        this.jmsObjectRepository = jmsObjectRepository;
    }

    public Completable send(String message, OutgoingMessageMetaData meta) {
        Objects.requireNonNull(message, "message must not be null");
        try {
            TextMessage textMessage = this.jmsObjectRepository.createTextMessage();
            if (meta.details != null) {
                textMessage.setJMSCorrelationID(((SendInfo)meta.details).correlationId);
                textMessage.setJMSReplyTo(((SendInfo)meta.details).replyDestination);
                if (((SendInfo)meta.details).customHeaders != null) {
                    for (String key : ((SendInfo)meta.details).customHeaders.keySet()) {
                        textMessage.setObjectProperty(key, ((SendInfo)meta.details).customHeaders.get(key));
                    }
                }
            }
            textMessage.setText(message);
            MessageProducer producer = this.jmsObjectRepository.createMessageProducer((Destination)meta.destination);
            if (meta.details == null) {
                producer.send((Message)textMessage);
            } else {
                producer.send((Message)textMessage, ((SendInfo)meta.details).deliveryMode.intValue(), ((SendInfo)meta.details).priority.intValue(), ((SendInfo)meta.details).timeToLive.longValue());
            }
            return Completable.complete();
        }
        catch (Exception e) {
            return Completable.error((Throwable)e);
        }
    }
}

