/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.DefaultMessageTranscriberForStringAsTransportType;
import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.jms.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.jms.MessageReceiver;
import ch.squaredesk.nova.comm.jms.MessageSender;
import ch.squaredesk.nova.comm.jms.OutgoingMessageMetaData;
import ch.squaredesk.nova.comm.jms.RetrieveInfo;
import ch.squaredesk.nova.comm.jms.RpcInvocation;
import ch.squaredesk.nova.comm.jms.SendInfo;
import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Flowable;
import java.util.Objects;
import javax.jms.Destination;

public class RpcServer
extends ch.squaredesk.nova.comm.rpc.RpcServer<Destination, String> {
    private final MessageSender messageSender;
    private final MessageReceiver messageReceiver;

    RpcServer(String identifier, MessageReceiver messageReceiver, MessageSender messageSender, Metrics metrics) {
        this(identifier, messageReceiver, messageSender, (MessageTranscriber<String>)new DefaultMessageTranscriberForStringAsTransportType(), metrics);
    }

    RpcServer(String identifier, MessageReceiver messageReceiver, MessageSender messageSender, MessageTranscriber<String> messageTranscriber, Metrics metrics) {
        super(identifier, messageTranscriber, metrics);
        Objects.requireNonNull(messageSender, "messageSender must not be null");
        Objects.requireNonNull(messageReceiver, "messageReceiver must not be null");
        this.messageSender = messageSender;
        this.messageReceiver = messageReceiver;
    }

    public <T> Flowable<RpcInvocation<T>> requests(Destination destination, Class<T> requestType) {
        return this.messageReceiver.messages(destination, this.messageTranscriber.getIncomingMessageTranscriber(requestType)).filter(this::isRpcRequest).map(incomingRequest -> {
            this.metricsCollector.requestReceived(incomingRequest.message);
            return new RpcInvocation(incomingRequest, reply -> {
                SendInfo sendingInfo = new SendInfo(((RetrieveInfo)((IncomingMessageMetaData)incomingRequest.metaData).details).correlationId, null, null, null, null, null);
                OutgoingMessageMetaData meta = new OutgoingMessageMetaData(((RetrieveInfo)((IncomingMessageMetaData)incomingRequest.metaData).details).replyDestination, sendingInfo);
                this.messageSender.send((String)reply._1, meta).subscribe();
                this.metricsCollector.requestCompleted(incomingRequest.message, reply);
            }, error -> this.metricsCollector.requestCompletedExceptionally(incomingRequest.message, error));
        });
    }

    private <T> boolean isRpcRequest(IncomingMessage<T, IncomingMessageMetaData> incomingMessage) {
        return incomingMessage.metaData != null && ((IncomingMessageMetaData)incomingMessage.metaData).details != null && ((RetrieveInfo)((IncomingMessageMetaData)incomingMessage.metaData).details).replyDestination != null && ((RetrieveInfo)((IncomingMessageMetaData)incomingMessage.metaData).details).correlationId != null;
    }
}

