/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.JmsSessionDescriptor;
import io.reactivex.Observable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JmsObjectRepository {
    private final Logger logger = LoggerFactory.getLogger(JmsObjectRepository.class);
    private final Map<String, MessageProducer> mapDestinationIdToMessageProducer = new ConcurrentHashMap<String, MessageProducer>();
    private Session producerSession;
    private Session consumerSession;
    private Destination tempQueue;
    private final Connection connection;
    private final JmsSessionDescriptor producerSessionDescriptor;
    private final JmsSessionDescriptor consumerSessionDescriptor;
    private final Function<Destination, String> destinationIdGenerator;

    JmsObjectRepository(Connection connection, JmsSessionDescriptor producerSessionDescriptor, JmsSessionDescriptor consumerSessionDescriptor, Function<Destination, String> destinationIdGenerator) {
        this.connection = connection;
        this.producerSessionDescriptor = producerSessionDescriptor;
        this.consumerSessionDescriptor = consumerSessionDescriptor;
        this.destinationIdGenerator = destinationIdGenerator;
    }

    Destination getPrivateTempQueue() {
        if (this.tempQueue == null) {
            try {
                this.tempQueue = this.consumerSession.createTemporaryQueue();
            }
            catch (JMSException e) {
                throw new RuntimeException("Unable to create temp queue", e);
            }
        }
        return this.tempQueue;
    }

    MessageConsumer createMessageConsumer(Destination destination) throws JMSException {
        return this.consumerSession.createConsumer(destination);
    }

    String idFor(Destination destination) {
        return this.destinationIdGenerator.apply(destination);
    }

    void destroyConsumer(MessageConsumer consumer) {
        Observable.timer((long)1L, (TimeUnit)TimeUnit.SECONDS).subscribe(x -> {
            try {
                TimeUnit.SECONDS.sleep(1L);
                consumer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    TextMessage createTextMessage() throws JMSException {
        return this.producerSession.createTextMessage();
    }

    MessageProducer createMessageProducer(Destination destination) {
        String destinationId = this.destinationIdGenerator.apply(destination);
        return this.mapDestinationIdToMessageProducer.computeIfAbsent(destinationId, key -> {
            try {
                return this.producerSession.createProducer(destination);
            }
            catch (JMSException e) {
                throw new RuntimeException(e);
            }
        });
    }

    void start() throws JMSException {
        this.connection.start();
        this.logger.debug("Creating producer session with the following settings: {}", (Object)this.producerSessionDescriptor);
        this.producerSession = this.connection.createSession(this.producerSessionDescriptor.transacted, this.producerSessionDescriptor.acknowledgeMode);
        this.logger.debug("Creating consumer session with the following settings: {}", (Object)this.consumerSessionDescriptor);
        this.consumerSession = this.connection.createSession(this.consumerSessionDescriptor.transacted, this.consumerSessionDescriptor.acknowledgeMode);
    }

    void shutdown() {
        this.mapDestinationIdToMessageProducer.forEach((key, value) -> {
            try {
                value.close();
            }
            catch (Exception e) {
                this.logger.warn("Unable to close producer for destination " + key, (Throwable)e);
            }
        });
        this.mapDestinationIdToMessageProducer.clear();
        try {
            this.consumerSession.close();
        }
        catch (Exception e) {
            this.logger.warn("Unable to close producer session", (Throwable)e);
        }
        try {
            this.producerSession.close();
        }
        catch (Exception e) {
            this.logger.warn("Unable to close producer session", (Throwable)e);
        }
        try {
            this.connection.close();
        }
        catch (Exception e) {
            this.logger.warn("Unable to close connection", (Throwable)e);
        }
    }
}

