/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.jms;

import ch.squaredesk.nova.comm.jms.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.jms.MessageReceiver;
import ch.squaredesk.nova.comm.jms.MessageSender;
import ch.squaredesk.nova.comm.jms.OutgoingMessageMetaData;
import ch.squaredesk.nova.comm.jms.RetrieveInfo;
import ch.squaredesk.nova.comm.jms.RpcReply;
import ch.squaredesk.nova.comm.jms.SendInfo;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Single;
import io.reactivex.functions.Function;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RpcClient
extends ch.squaredesk.nova.comm.rpc.RpcClient<String, OutgoingMessageMetaData, IncomingMessageMetaData> {
    private final MessageSender messageSender;
    private final MessageReceiver messageReceiver;

    RpcClient(String identifier, MessageSender messageSender, MessageReceiver messageReceiver, Metrics metrics) {
        super(identifier, metrics);
        this.messageSender = messageSender;
        this.messageReceiver = messageReceiver;
    }

    public <RequestType, ReplyType> Single<RpcReply<ReplyType>> sendRequest(RequestType request, OutgoingMessageMetaData requestMetaData, Function<RequestType, String> requestTranscriber, Function<String, ReplyType> replyTranscriber, long timeout, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "timeUnit must not be null");
        Objects.requireNonNull(requestMetaData, "metaData must not be null");
        Objects.requireNonNull((SendInfo)requestMetaData.details, "metaData.details must not be null");
        Objects.requireNonNull(((SendInfo)requestMetaData.details).correlationId, "correlationId must not be null");
        Objects.requireNonNull(((SendInfo)requestMetaData.details).replyDestination, "replyDestination must not be null");
        Single replySingle = this.messageReceiver.messages(((SendInfo)requestMetaData.details).replyDestination, replyTranscriber).filter(incomingMessage -> ((IncomingMessageMetaData)incomingMessage.metaData).details != null && ((SendInfo)requestMetaData.details).correlationId.equals(((RetrieveInfo)((IncomingMessageMetaData)incomingMessage.metaData).details).correlationId)).take(1L).doOnNext(reply -> this.metricsCollector.rpcCompleted(request, reply)).map(incomingMessage -> new RpcReply<Object>(incomingMessage.message, (IncomingMessageMetaData)incomingMessage.metaData)).singleOrError();
        Throwable sendError = this.messageSender.send(request, requestMetaData, requestTranscriber).blockingGet();
        if (sendError != null) {
            return Single.error((Throwable)sendError);
        }
        return replySingle.timeout(timeout, timeUnit).doOnError(t -> {
            if (t instanceof TimeoutException) {
                this.metricsCollector.rpcTimedOut(request);
            }
        });
    }
}

