/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.kafka;

import ch.squaredesk.nova.comm.kafka.KafkaSpecificInfo;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.sending.MessageSender;
import ch.squaredesk.nova.comm.sending.MessageSendingInfo;
import ch.squaredesk.nova.metrics.Metrics;
import io.reactivex.Completable;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

class KafkaMessageSender<InternalMessageType>
extends MessageSender<String, InternalMessageType, String, KafkaSpecificInfo> {
    private final Producer<String, String> producer;

    KafkaMessageSender(String identifier, Properties producerProperties, MessageMarshaller<InternalMessageType, String> messageMarshaller, Metrics metrics) {
        super(identifier, messageMarshaller, metrics);
        this.producer = new KafkaProducer(producerProperties);
    }

    public Completable doSend(String message, MessageSendingInfo<String, KafkaSpecificInfo> sendingInfo) {
        Objects.requireNonNull(message, "message must not be null");
        ProducerRecord record = new ProducerRecord((String)sendingInfo.destination, (Object)message);
        return Completable.fromFuture((Future)this.producer.send(record));
    }
}

