/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.CompoundMetric;
import ch.squaredesk.nova.metrics.MetricsDump;
import ch.squaredesk.nova.tuples.Pair;
import ch.squaredesk.nova.tuples.Tuple3;
import com.codahale.metrics.Metric;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;

public class MetricsDumpToMapConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private MetricsDumpToMapConverter() {
    }

    public static Map<String, Object> convert(MetricsDump dump) {
        return MetricsDumpToMapConverter.convert(dump, null);
    }

    public static Map<String, Object> convert(MetricsDump dump, Map<String, Object> additionalAttributes) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        dump.metrics.entrySet().stream().map(entry -> new Tuple3((Object)((Metric)entry.getValue()).getClass().getSimpleName(), entry.getKey(), entry.getValue())).map(tupleTypeAndNameAndMetric -> {
            Map<String, Object> map = MetricsDumpToMapConverter.toMap((Metric)tupleTypeAndNameAndMetric._3);
            map.put("type", tupleTypeAndNameAndMetric._1);
            if (additionalAttributes != null) {
                map.putAll(additionalAttributes);
            }
            return new Pair(tupleTypeAndNameAndMetric._2, map);
        }).forEach(metricNameMapPair -> returnValue.put((String)metricNameMapPair._1, metricNameMapPair._2));
        returnValue.put("timestamp", dump.timestamp);
        returnValue.put("hostName", dump.hostName);
        returnValue.put("hostAddress", dump.hostAddress);
        return returnValue;
    }

    private static Map<String, Object> toMap(Metric metric) {
        if (metric instanceof CompoundMetric) {
            return ((CompoundMetric)metric).getValues();
        }
        return (Map)objectMapper.convertValue((Object)metric, Map.class);
    }
}

