/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.metrics;

import ch.squaredesk.nova.metrics.CompoundMetric;
import ch.squaredesk.nova.tuples.Pair;
import ch.squaredesk.nova.tuples.Tuple3;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.metrics5.Metric;
import io.dropwizard.metrics5.MetricName;
import java.util.HashMap;
import java.util.Map;

public class MetricsConverter {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private MetricsConverter() {
    }

    public static Map<String, Map<String, Object>> convert(Map<MetricName, Metric> dump) {
        return MetricsConverter.convert(dump, null);
    }

    public static Map<String, Map<String, Object>> convert(Map<MetricName, Metric> dump, Map<String, Object> additionalAttributes) {
        HashMap<String, Map<String, Object>> returnValue = new HashMap<String, Map<String, Object>>();
        dump.entrySet().stream().map(entry -> new Tuple3((Object)((Metric)entry.getValue()).getClass().getSimpleName(), entry.getKey(), entry.getValue())).map(tupleTypeAndNameAndMetric -> {
            Map<String, Object> map = MetricsConverter.toMap((Metric)tupleTypeAndNameAndMetric._3);
            map.put("type", tupleTypeAndNameAndMetric._1);
            if (additionalAttributes != null) {
                map.putAll(additionalAttributes);
            }
            return new Pair(tupleTypeAndNameAndMetric._2, map);
        }).forEach(metricNameMapPair -> {
            Map cfr_ignored_0 = (Map)returnValue.put(((MetricName)metricNameMapPair._1).toString(), (Map<String, Object>)metricNameMapPair._2);
        });
        return returnValue;
    }

    private static Map<String, Object> toMap(CompoundMetric compoundMetric) {
        HashMap<String, Object> returnValue = new HashMap<String, Object>();
        Map values = compoundMetric.getValues();
        if (!values.isEmpty()) {
            values.forEach((key, value) -> returnValue.put(key.toString(), value));
        }
        returnValue.put("type", compoundMetric.getClass().getSimpleName());
        return returnValue;
    }

    private static Map<String, Object> toMap(Metric metric) {
        if (metric instanceof CompoundMetric) {
            return MetricsConverter.toMap((CompoundMetric)metric);
        }
        Map map = (Map)objectMapper.convertValue((Object)metric, Map.class);
        map.put("type", metric.getClass().getSimpleName());
        return map;
    }
}

