/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rest;

import ch.squaredesk.nova.Nova;
import ch.squaredesk.nova.comm.http.HttpServerConfiguration;
import ch.squaredesk.nova.comm.http.spring.HttpServerConfigurationProvidingConfiguration;
import ch.squaredesk.nova.comm.rest.RestBeanPostprocessor;
import ch.squaredesk.nova.comm.rest.RestServerStarter;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.metrics5.Timer;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.monitoring.ApplicationEvent;
import org.glassfish.jersey.server.monitoring.ApplicationEventListener;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={HttpServerConfigurationProvidingConfiguration.class})
@Order
public class RestEnablingConfiguration {
    @Autowired
    Environment environment;
    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    Nova nova;
    @Autowired
    HttpServerConfiguration httpServerConfiguration;
    @Autowired(required=false)
    ObjectMapper restObjectMapper;

    @Bean
    public static RestBeanPostprocessor restBeanPostProcessor() {
        return new RestBeanPostprocessor();
    }

    @Bean(name={"captureRestMetrics"})
    public boolean captureRestMetrics() {
        boolean captureMetrics = true;
        try {
            captureMetrics = Boolean.valueOf(this.environment.getProperty("NOVA.HTTP.REST.CAPTURE_METRICS", "true"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return captureMetrics;
    }

    @Bean(value={"autoStartRestServer"})
    public boolean autoStartRestServer() {
        return (Boolean)this.environment.getProperty("NOVA.HTTP.REST.SERVER.AUTO_START", Boolean.class, (Object)true);
    }

    @Bean
    RestServerStarter restServerStarter() {
        return new RestServerStarter(this.autoStartRestServer());
    }

    @Lazy
    @Bean(value={"httpServer"})
    public HttpServer restHttpServer() {
        RestBeanPostprocessor restBeanPostprocessor = (RestBeanPostprocessor)this.applicationContext.getBean(RestBeanPostprocessor.class);
        ResourceConfig resourceConfig = new ResourceConfig().register(MultiPartFeature.class).register(JacksonFeature.class);
        SpecificRestObjectMapperProvider.STATIC_OBJECT_MAPPER = this.restObjectMapper != null ? this.restObjectMapper : new ObjectMapper().findAndRegisterModules();
        resourceConfig.register(SpecificRestObjectMapperProvider.class);
        resourceConfig.registerInstances(restBeanPostprocessor.handlerBeans.toArray());
        if (this.captureRestMetrics() && this.nova != null) {
            final RequestEventListener requestEventListener = event -> {
                String eventId = event.getContainerRequest().getPath(true);
                Timer timer = this.nova.metrics.getTimer("rest", new String[]{eventId});
                if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_START) {
                    event.getContainerRequest().setProperty("metricsContext", (Object)timer.time());
                } else if (event.getType() == RequestEvent.Type.RESOURCE_METHOD_FINISHED) {
                    ((Timer.Context)event.getContainerRequest().getProperty("metricsContext")).stop();
                    this.nova.metrics.getCounter("rest", new String[]{eventId, "total"}).inc();
                    if (event.getException() != null) {
                        this.nova.metrics.getCounter("rest", new String[]{eventId, "errors"}).inc();
                    }
                }
            };
            resourceConfig.register((Object)new ApplicationEventListener(){

                public void onEvent(ApplicationEvent event) {
                }

                public RequestEventListener onRequest(RequestEvent requestEvent) {
                    return requestEventListener;
                }
            });
        }
        URI serverAddress = UriBuilder.fromPath((String)("http://" + this.httpServerConfiguration.interfaceName + ":" + this.httpServerConfiguration.port)).build(new Object[0]);
        return GrizzlyHttpServerFactory.createHttpServer((URI)serverAddress, (ResourceConfig)resourceConfig, (boolean)false);
    }

    @Provider
    public static class SpecificRestObjectMapperProvider
    implements ContextResolver<ObjectMapper> {
        public static ObjectMapper STATIC_OBJECT_MAPPER;

        public ObjectMapper getContext(Class<?> type) {
            return STATIC_OBJECT_MAPPER;
        }
    }
}

