/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.rest;

import java.io.IOException;
import javax.annotation.PreDestroy;
import org.glassfish.grizzly.http.server.HttpServer;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class RestServerStarter
implements ApplicationListener<ContextRefreshedEvent> {
    private HttpServer httpServer;
    private boolean autoStartServerWhenApplicationContextRefreshed;

    public RestServerStarter(boolean autoStartServerWhenApplicationContextRefreshed) {
        this.autoStartServerWhenApplicationContextRefreshed = autoStartServerWhenApplicationContextRefreshed;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.httpServer = (HttpServer)event.getApplicationContext().getBean(HttpServer.class);
        if (this.autoStartServerWhenApplicationContextRefreshed) {
            try {
                this.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void start() throws IOException {
        if (!this.httpServer.isStarted()) {
            this.httpServer.start();
        }
    }

    @PreDestroy
    public void shutdown() {
        if (this.httpServer != null) {
            this.httpServer.shutdown();
        }
    }
}

