/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.service.annotation;

import ch.squaredesk.nova.service.annotation.OnServiceInit;
import ch.squaredesk.nova.service.annotation.OnServiceShutdown;
import ch.squaredesk.nova.service.annotation.OnServiceStartup;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;

class BeanExaminer {
    BeanExaminer() {
    }

    Method[] shutdownHandlersIn(Object bean) {
        return this.handlersIn(bean, OnServiceShutdown.class);
    }

    Method[] startupHandlersIn(Object bean) {
        return this.handlersIn(bean, OnServiceStartup.class);
    }

    Method[] initHandlersIn(Object bean) {
        return this.handlersIn(bean, OnServiceInit.class);
    }

    private Method[] handlersIn(Object bean, Class expectedAnnotationClass) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        return (Method[])Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(anno -> expectedAnnotationClass.isAssignableFrom(anno.getClass()))).peek(method -> {
            if (!Modifier.isPublic(method.getModifiers())) {
                throw new IllegalArgumentException("Method " + BeanExaminer.prettyPrint(bean, method) + ", annotated with @" + expectedAnnotationClass.getSimpleName() + " must be public");
            }
        }).peek(method -> {
            if (method.getParameterCount() > 0) {
                throw new IllegalArgumentException("Method " + BeanExaminer.prettyPrint(bean, method) + ", annotated with @" + expectedAnnotationClass.getSimpleName() + " must not declare any parameters");
            }
        }).toArray(Method[]::new);
    }

    private static String prettyPrint(Object bean, Method method) {
        StringBuilder sb = new StringBuilder(bean.getClass().getName()).append('.').append(method.getName()).append('(').append(Arrays.stream(method.getParameterTypes()).map(paramterClass -> paramterClass.getSimpleName()).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

