/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.service;

import ch.squaredesk.nova.Nova;
import ch.squaredesk.nova.service.NovaServiceConfiguration;
import ch.squaredesk.nova.service.annotation.LifecycleBeanProcessor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

public abstract class NovaService {
    private Lifeline lifeline = new Lifeline();
    private boolean started = false;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    AnnotationConfigApplicationContext applicationContext;
    @Autowired
    boolean registerShutdownHook;
    @Autowired
    LifecycleBeanProcessor lifecycleBeanProcessor;
    @Autowired
    protected Nova nova;
    @Autowired
    protected String instanceId;
    @Autowired
    protected String serviceName;

    protected NovaService() {
    }

    private void doInit() {
        Objects.requireNonNull(this.nova);
        if (this.registerShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown()));
        }
        this.lifecycleBeanProcessor.invokeInitHandlers();
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("service " + this.serviceName + "/" + this.instanceId + " already started");
        }
        this.lifecycleBeanProcessor.invokeStartupHandlers();
        this.lifeline.start();
        this.started = true;
        this.logger.info("Service {}, instance {} up and running.", (Object)this.serviceName, (Object)this.instanceId);
    }

    public void shutdown() {
        if (this.started) {
            this.logger.info("Service {}, instance {} is shutting down...", (Object)this.serviceName, (Object)this.instanceId);
            try {
                this.lifecycleBeanProcessor.invokeShutdownHandlers();
            }
            catch (Exception e) {
                this.logger.warn("Error in shutdown procedure of instance " + this.instanceId, (Throwable)e);
            }
            this.lifeline.cut();
            this.lifeline = new Lifeline();
            this.started = false;
            this.applicationContext.close();
            this.logger.info("Shutdown procedure completed for service {}, instance {}.", (Object)this.serviceName, (Object)this.instanceId);
        }
    }

    public boolean isStarted() {
        return this.started;
    }

    private static void assertIsAnnotated(Class classToCheck, Class annotationToCheckFor) {
        boolean annotated = Arrays.stream(classToCheck.getAnnotations()).anyMatch(anno -> anno.annotationType().equals(annotationToCheckFor));
        if (!annotated) {
            throw new IllegalArgumentException("the class " + classToCheck.getName() + " must be annotated with @" + annotationToCheckFor.getSimpleName());
        }
    }

    private static void assertIsAnnotated(Class classToCheck, String methodToFind, Class annotationToCheckFor) {
        Method methodToCheck;
        try {
            methodToCheck = classToCheck.getMethod(methodToFind, new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to instantiate service", e);
        }
        boolean annotated = Arrays.stream(methodToCheck.getAnnotations()).anyMatch(anno -> anno.annotationType().equals(annotationToCheckFor));
        if (!annotated) {
            throw new IllegalArgumentException("the method " + methodToFind + "() must be annotated with @" + annotationToCheckFor.getSimpleName());
        }
    }

    public static <T extends NovaService, U extends NovaServiceConfiguration<T>> T createInstance(Class<T> serviceClass, Class<U> configurationClass) {
        NovaService.assertIsAnnotated(configurationClass, Configuration.class);
        NovaService.assertIsAnnotated(configurationClass, "serviceInstance", Bean.class);
        AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
        ctx.register(new Class[]{configurationClass});
        ctx.refresh();
        NovaService service = (NovaService)ctx.getBean(serviceClass);
        service.doInit();
        return (T)service;
    }

    private class Lifeline
    extends Thread {
        private final CountDownLatch shutdownLatch;

        private Lifeline() {
            super("Lifeline");
            this.shutdownLatch = new CountDownLatch(1);
        }

        @Override
        public void run() {
            try {
                this.shutdownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        void cut() {
            this.shutdownLatch.countDown();
        }
    }
}

