/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.service;

import ch.squaredesk.nova.events.annotation.AnnotationEnablingConfiguration;
import ch.squaredesk.nova.events.annotation.NovaProvidingConfiguration;
import ch.squaredesk.nova.service.annotation.LifecycleBeanProcessor;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.PropertySources;
import org.springframework.core.env.Environment;

@Configuration
@PropertySources(value={@PropertySource(value={"classpath:defaults.properties"}, ignoreResourceNotFound=true), @PropertySource(value={"file:${NOVA.SERVICE.CONFIG}"}, ignoreResourceNotFound=true), @PropertySource(value={"classpath:${NOVA.SERVICE.CONFIG}"}, ignoreResourceNotFound=true)})
@Import(value={AnnotationEnablingConfiguration.class, NovaProvidingConfiguration.class})
public abstract class NovaServiceConfiguration<ServiceType> {
    @Autowired
    protected Environment environment;

    @Bean(name={"instanceId"})
    public String instanceId() {
        return this.environment.getProperty("NOVA.SERVICE.INSTANCE_ID", UUID.randomUUID().toString());
    }

    @Bean(name={"serviceName"})
    public String serviceName() {
        String name = this.environment.getProperty("NOVA.SERVICE.NAME", (String)null);
        if (name == null) {
            String configClassName = this.getClass().getSimpleName();
            Optional<Integer> indexOfConfigSubstring = Stream.of("config", "conf", "cfg").map(testString -> configClassName.toLowerCase().indexOf((String)testString)).max(Integer::compareTo);
            name = configClassName.substring(0, indexOfConfigSubstring.orElse(configClassName.length()));
        }
        return name;
    }

    @Bean
    public static LifecycleBeanProcessor lifecycleBeanProcessor() {
        return new LifecycleBeanProcessor();
    }

    @Bean
    public boolean registerShutdownHook() {
        boolean registerShutdownHook = true;
        try {
            registerShutdownHook = Boolean.parseBoolean(this.environment.getProperty("NOVA.SERVICE.REGISTER_SHUTDOWN_HOOK", "TRUE"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registerShutdownHook;
    }

    public abstract ServiceType serviceInstance();
}

