/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.service.annotation;

import ch.squaredesk.nova.service.annotation.BeanExaminer;
import ch.squaredesk.nova.tuples.Pair;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class LifecycleBeanProcessor
implements BeanPostProcessor {
    private final Logger logger = LoggerFactory.getLogger(LifecycleBeanProcessor.class);
    private final BeanExaminer beanExaminer = new BeanExaminer();
    private final CopyOnWriteArrayList<Pair<Object, Method[]>> initHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Pair<Object, Method[]>> startupHandlers = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<Pair<Object, Method[]>> shutdownHandlers = new CopyOnWriteArrayList();

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        Method[] handlers = this.beanExaminer.initHandlersIn(bean);
        if (handlers.length > 0) {
            this.initHandlers.add((Pair<Object, Method[]>)new Pair(bean, (Object)handlers));
        }
        if ((handlers = this.beanExaminer.startupHandlersIn(bean)).length > 0) {
            this.startupHandlers.add((Pair<Object, Method[]>)new Pair(bean, (Object)handlers));
        }
        if ((handlers = this.beanExaminer.shutdownHandlersIn(bean)).length > 0) {
            this.shutdownHandlers.add((Pair<Object, Method[]>)new Pair(bean, (Object)handlers));
        }
        return bean;
    }

    public void invokeInitHandlers() {
        this.invokeHandlers(this.initHandlers, t -> {
            throw new BeanInitializationException("Error invoking init handler", t);
        });
    }

    public void invokeStartupHandlers() {
        this.invokeHandlers(this.startupHandlers, t -> {
            throw new RuntimeException("Error invoking startup handler", (Throwable)t);
        });
    }

    public void invokeShutdownHandlers() {
        this.invokeHandlers(this.shutdownHandlers, t -> this.logger.warn("Error invoking shutdown handler", t));
    }

    private void invokeHandlers(List<Pair<Object, Method[]>> handlers, Consumer<Throwable> exceptionHandler) {
        for (Pair<Object, Method[]> pair : handlers) {
            for (Method handlerMethod : (Method[])pair._2) {
                try {
                    handlerMethod.invoke(pair._1, new Object[0]);
                }
                catch (Throwable t) {
                    exceptionHandler.accept(t);
                }
            }
        }
    }
}

