/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.websockets.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.RetrieveInfo;
import ch.squaredesk.nova.comm.websockets.annotation.EndpointDescriptor;
import io.reactivex.functions.Consumer;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MethodInvoker<MessageType>
implements Consumer<IncomingMessage<MessageType, IncomingMessageMetaData<MessageType>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodInvoker.class);
    private final Object objectToInvokeMethodOn;
    private final Method methodToInvoke;
    private final MetricsCollector metricsCollector;

    private MethodInvoker(Object objectToInvokeMethodOn, Method methodToInvoke, MetricsCollector metricsCollector) {
        this.objectToInvokeMethodOn = objectToInvokeMethodOn;
        this.methodToInvoke = methodToInvoke;
        this.metricsCollector = metricsCollector;
    }

    public void accept(IncomingMessage<MessageType, IncomingMessageMetaData<MessageType>> message) throws Exception {
        try {
            this.methodToInvoke.invoke(this.objectToInvokeMethodOn, message.message, ((RetrieveInfo)((IncomingMessageMetaData)message.metaData).details).webSocket);
        }
        catch (Throwable t) {
            LOGGER.error("Unable to invoke handler for message " + message, t);
        }
    }

    static <MessageType> MethodInvoker<MessageType> createFor(EndpointDescriptor endpointDescriptor, MetricsCollector metricsCollector) {
        return new MethodInvoker<MessageType>(endpointDescriptor.objectToInvokeMethodOn, endpointDescriptor.methodToInvoke, (MetricsCollector)(endpointDescriptor.captureTimings ? metricsCollector : null));
    }
}

