/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.annotation.BeanExaminer;
import ch.squaredesk.nova.comm.websockets.annotation.EndpointDescriptor;
import ch.squaredesk.nova.comm.websockets.annotation.MethodInvoker;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpoint;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpointFactory;
import io.reactivex.Flowable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WebSocketBeanPostprocessor
implements BeanPostProcessor {
    private final MessageMarshaller messageMarshaller;
    private final MessageUnmarshaller messageUnmarshaller;
    private final MetricsCollector metricsCollector;
    private final ServerEndpointFactory serverEndpointFactory = new ServerEndpointFactory();

    public WebSocketBeanPostprocessor(MessageMarshaller<?, String> messageMarshaller, MessageUnmarshaller<String, ?> messageUnmarshaller, MetricsCollector metricsCollector) {
        this.messageMarshaller = messageMarshaller;
        this.messageUnmarshaller = messageUnmarshaller;
        this.metricsCollector = metricsCollector;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        EndpointDescriptor[] endpoints;
        for (EndpointDescriptor endpointDescriptor : endpoints = BeanExaminer.websocketEndpointsIn(bean)) {
            ServerEndpoint se = this.serverEndpointFactory.createFor(endpointDescriptor.destination, this.messageMarshaller, this.messageUnmarshaller, endpointDescriptor.captureTimings ? this.metricsCollector : null);
            Flowable messages = se.messages();
            if (endpointDescriptor.backpressureStrategy != null) {
                switch (endpointDescriptor.backpressureStrategy) {
                    case BUFFER: {
                        messages = messages.onBackpressureBuffer();
                        break;
                    }
                    case DROP: {
                        messages = messages.onBackpressureDrop();
                        break;
                    }
                    case LATEST: {
                        messages = messages.onBackpressureLatest();
                    }
                }
            }
            messages.subscribe(MethodInvoker.createFor(endpointDescriptor, this.metricsCollector));
        }
        return bean;
    }
}

