/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.comm.DefaultMarshallerFactory;
import ch.squaredesk.nova.comm.ReflectionHelper;
import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.comm.websockets.annotation.EndpointDescriptor;
import ch.squaredesk.nova.comm.websockets.annotation.OnMessage;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class BeanExaminer {
    private static final Predicate<Annotation> interestingAnnotation = anno -> anno instanceof OnMessage;

    private BeanExaminer() {
    }

    static EndpointDescriptor[] websocketEndpointsIn(Object bean) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        return (EndpointDescriptor[])Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(interestingAnnotation)).peek(method -> {
            if (!BeanExaminer.methodSignatureValidForMessageHandler(method)) {
                throw new IllegalArgumentException("Method " + BeanExaminer.prettyPrint(bean, method) + ", annotated with @" + OnMessage.class.getSimpleName() + " has an invalid signature");
            }
        }).map(method -> {
            OnMessage annotation = Arrays.stream(method.getDeclaredAnnotations()).filter(interestingAnnotation).findFirst().map(anno -> (OnMessage)anno).get();
            MessageMarshaller marshaller = BeanExaminer.instantiateMarshaller(method, annotation);
            MessageUnmarshaller unmarshaller = BeanExaminer.instantiateUnmarshaller(method, annotation);
            return new EndpointDescriptor(bean, (Method)method, annotation.value(), marshaller, unmarshaller, annotation.captureTimings(), annotation.backpressureStrategy());
        }).toArray(EndpointDescriptor[]::new);
    }

    private static boolean methodSignatureValidForMessageHandler(Method m) {
        return m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 2 && m.getParameterTypes()[1].isAssignableFrom(WebSocket.class);
    }

    private static MessageMarshaller instantiateMarshaller(Method method, OnMessage annotation) {
        if (!annotation.messageMarshallerClassName().isEmpty()) {
            return BeanExaminer.instantiateMarshaller(method, annotation.messageMarshallerClassName());
        }
        return DefaultMarshallerFactory.getMarshallerForMessageType(method.getParameterTypes()[0]);
    }

    private static MessageUnmarshaller instantiateUnmarshaller(Method method, OnMessage annotation) {
        if (!annotation.messageUnmarshallerClassName().isEmpty()) {
            return BeanExaminer.instantiateUnmarshaller(method, annotation.messageUnmarshallerClassName());
        }
        return DefaultMarshallerFactory.getUnmarshallerForMessageType(method.getParameterTypes()[0]);
    }

    private static boolean marshallerAcceptsType(MessageMarshaller<?, String> marshaller, Class paramTypeToCheckFor) {
        Class concreteClass = ReflectionHelper.getConcreteTypeOfGenericInterfaceImplementation(marshaller, MessageMarshaller.class, (int)0);
        return concreteClass != null && concreteClass.isAssignableFrom(paramTypeToCheckFor);
    }

    private static boolean unmarshallerReturnsType(MessageUnmarshaller unmarshaller, Class returnTypeToCheckFor) {
        Class concreteClass = ReflectionHelper.getConcreteTypeOfGenericInterfaceImplementation((Object)unmarshaller, MessageUnmarshaller.class, (int)1);
        return concreteClass != null && concreteClass.isAssignableFrom(returnTypeToCheckFor);
    }

    private static MessageMarshaller instantiateMarshaller(Method method, String className) {
        Object instance = ReflectionHelper.instanceFromClassName((String)className);
        if (!(instance instanceof MessageMarshaller)) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageMarshaller");
        }
        MessageMarshaller messageMarshaller = (MessageMarshaller)instance;
        if (!BeanExaminer.marshallerAcceptsType(messageMarshaller, method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageMarshaller for method " + method.getName());
        }
        return messageMarshaller;
    }

    private static MessageUnmarshaller instantiateUnmarshaller(Method method, String className) {
        Object instance = ReflectionHelper.instanceFromClassName((String)className);
        if (!(instance instanceof MessageUnmarshaller)) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageUnmarshaller");
        }
        MessageUnmarshaller messageUnmarshaller = (MessageUnmarshaller)instance;
        if (!BeanExaminer.unmarshallerReturnsType(messageUnmarshaller, method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageUnmarshaller for method " + method.getName());
        }
        return messageUnmarshaller;
    }

    private static String prettyPrint(Object bean, Method method) {
        StringBuilder sb = new StringBuilder(bean.getClass().getName()).append('.').append(method.getName()).append('(').append(Arrays.stream(method.getParameterTypes()).map(paramterClass -> paramterClass.getSimpleName()).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

