/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.ReflectionHelper;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.comm.websockets.annotation.EndpointDescriptor;
import ch.squaredesk.nova.comm.websockets.annotation.OnMessage;
import io.reactivex.functions.Function;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class BeanExaminer {
    private static final Predicate<Annotation> interestingAnnotation = anno -> anno instanceof OnMessage;
    private final MessageTranscriber<String> defaultMessageTranscriber;

    BeanExaminer(MessageTranscriber<String> messageTranscriber) {
        this.defaultMessageTranscriber = messageTranscriber;
    }

    EndpointDescriptor[] websocketEndpointsIn(Object bean) {
        Objects.requireNonNull(bean, "bean to examine must not be null");
        return (EndpointDescriptor[])Arrays.stream(bean.getClass().getDeclaredMethods()).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(interestingAnnotation)).peek(method -> {
            if (!BeanExaminer.methodSignatureValidForMessageHandler(method)) {
                throw new IllegalArgumentException("Method " + BeanExaminer.prettyPrint(bean, method) + ", annotated with @" + OnMessage.class.getSimpleName() + " has an invalid signature");
            }
        }).map(method -> {
            OnMessage annotation = Arrays.stream(method.getDeclaredAnnotations()).filter(interestingAnnotation).findFirst().map(anno -> (OnMessage)anno).get();
            Class<?> messageType = BeanExaminer.getMessageTypeFromHandlerMethod(method);
            Function<?, String> marshaller = this.instantiateMarshaller((Method)method, annotation, messageType);
            Function<String, ?> unmarshaller = this.instantiateUnmarshaller((Method)method, annotation, messageType);
            return new EndpointDescriptor(bean, (Method)method, annotation.value(), messageType, marshaller, unmarshaller, annotation.captureTimings(), annotation.backpressureStrategy());
        }).toArray(EndpointDescriptor[]::new);
    }

    private static boolean methodSignatureValidForMessageHandler(Method m) {
        return m.getReturnType() == Void.TYPE && m.getParameterTypes().length == 2 && m.getParameterTypes()[1].isAssignableFrom(WebSocket.class);
    }

    private static Class<?> getMessageTypeFromHandlerMethod(Method method) {
        return method.getParameterTypes()[0];
    }

    private Function<?, String> instantiateMarshaller(Method method, OnMessage annotation, Class<?> messageType) {
        if (!annotation.messageMarshallerClassName().isEmpty()) {
            return BeanExaminer.instantiateMarshaller(method, annotation.messageMarshallerClassName());
        }
        return this.defaultMessageTranscriber.getOutgoingMessageTranscriber(messageType);
    }

    private Function<String, ?> instantiateUnmarshaller(Method method, OnMessage annotation, Class<?> messageType) {
        if (!annotation.messageUnmarshallerClassName().isEmpty()) {
            return BeanExaminer.instantiateUnmarshaller(method, annotation.messageUnmarshallerClassName());
        }
        return this.defaultMessageTranscriber.getIncomingMessageTranscriber(messageType);
    }

    private static boolean marshallerAcceptsType(Function<?, String> marshaller, Class paramTypeToCheckFor) {
        Class concreteClass = ReflectionHelper.getConcreteTypeOfGenericInterfaceImplementation(marshaller, Function.class, (int)0);
        return concreteClass != null && concreteClass.isAssignableFrom(paramTypeToCheckFor);
    }

    private static boolean unmarshallerReturnsType(Function<String, ?> unmarshaller, Class returnTypeToCheckFor) {
        Class concreteClass = ReflectionHelper.getConcreteTypeOfGenericInterfaceImplementation(unmarshaller, Function.class, (int)1);
        return concreteClass != null && concreteClass.isAssignableFrom(returnTypeToCheckFor);
    }

    private static Function<?, String> instantiateMarshaller(Method method, String className) {
        Object instance = ReflectionHelper.instanceFromClassName((String)className);
        if (!(instance instanceof Function)) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageMarshaller");
        }
        Function messageMarshaller = (Function)instance;
        if (!BeanExaminer.marshallerAcceptsType(messageMarshaller, method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageMarshaller for method " + method.getName());
        }
        return messageMarshaller;
    }

    private static Function<String, ?> instantiateUnmarshaller(Method method, String className) {
        Object instance = ReflectionHelper.instanceFromClassName((String)className);
        if (!(instance instanceof Function)) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageUnmarshaller");
        }
        Function messageUnmarshaller = (Function)instance;
        if (!BeanExaminer.unmarshallerReturnsType(messageUnmarshaller, method.getParameterTypes()[0])) {
            throw new IllegalArgumentException("Class " + className + " is not a valid MessageUnmarshaller for method " + method.getName());
        }
        return messageUnmarshaller;
    }

    private static String prettyPrint(Object bean, Method method) {
        StringBuilder sb = new StringBuilder(bean.getClass().getName()).append('.').append(method.getName()).append('(').append(Arrays.stream(method.getParameterTypes()).map(paramterClass -> paramterClass.getSimpleName()).collect(Collectors.joining(", "))).append(')');
        return sb.toString();
    }
}

