/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.annotation.BeanExaminer;
import ch.squaredesk.nova.comm.websockets.annotation.EndpointDescriptor;
import ch.squaredesk.nova.comm.websockets.annotation.MethodInvoker;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpoint;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpointFactory;
import io.reactivex.Flowable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class WebSocketBeanPostprocessor
implements BeanPostProcessor {
    private final MetricsCollector metricsCollector;
    private final ServerEndpointFactory serverEndpointFactory;
    private final BeanExaminer beanExaminer;

    public WebSocketBeanPostprocessor(MessageTranscriber<String> messageTranscriber, MetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
        this.serverEndpointFactory = new ServerEndpointFactory(messageTranscriber);
        this.beanExaminer = new BeanExaminer(messageTranscriber);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        EndpointDescriptor[] endpoints;
        for (EndpointDescriptor endpointDescriptor : endpoints = this.beanExaminer.websocketEndpointsIn(bean)) {
            ServerEndpoint se = this.serverEndpointFactory.createFor(endpointDescriptor.destination, endpointDescriptor.captureTimings ? this.metricsCollector : null);
            Flowable messages = se.messages(endpointDescriptor.messageType);
            if (endpointDescriptor.backpressureStrategy != null) {
                switch (endpointDescriptor.backpressureStrategy) {
                    case BUFFER: {
                        messages = messages.onBackpressureBuffer();
                        break;
                    }
                    case DROP: {
                        messages = messages.onBackpressureDrop();
                        break;
                    }
                    case LATEST: {
                        messages = messages.onBackpressureLatest();
                    }
                }
            }
            messages.subscribe(MethodInvoker.createFor(endpointDescriptor, this.metricsCollector));
        }
        return bean;
    }
}

