/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.annotation;

import ch.squaredesk.nova.Nova;
import ch.squaredesk.nova.comm.DefaultMessageTranscriberForStringAsTransportType;
import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.http.spring.HttpServerProvidingConfiguration;
import ch.squaredesk.nova.comm.http.spring.HttpServerStarter;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.annotation.WebSocketBeanPostprocessor;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.websockets.WebSocketAddOn;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.core.env.Environment;

@Configuration
@Import(value={HttpServerProvidingConfiguration.class})
public class WebSocketEnablingConfiguration {
    @Autowired
    Environment environment;
    @Autowired
    Nova nova;
    @Autowired
    HttpServer httpServer;

    @Bean(value={"defaultWebsocketMessageTranscriber"})
    MessageTranscriber<String> defaultWebsocketMessageTranscriber() {
        return new DefaultMessageTranscriberForStringAsTransportType();
    }

    @Bean
    public WebSocketBeanPostprocessor webSocketBeanPostProcessor() {
        WebSocketAddOn addon = new WebSocketAddOn();
        for (NetworkListener listener : this.httpServer.getListeners()) {
            listener.registerAddOn((AddOn)addon);
        }
        return new WebSocketBeanPostprocessor(this.defaultWebsocketMessageTranscriber(), new MetricsCollector(this.nova.metrics));
    }

    @Bean
    AsyncHttpClient httpClient() {
        AsyncHttpClientConfig cf = new AsyncHttpClientConfig.Builder().build();
        return new AsyncHttpClient(cf);
    }

    @Bean
    HttpServerStarter httpServerStarter() {
        return new HttpServerStarter();
    }
}

