/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class WebSocket<MessageType> {
    private final Consumer<MessageType> sendAction;
    private final Runnable closeAction;
    private final ConcurrentHashMap<String, Object> userProperties = new ConcurrentHashMap(1);

    public WebSocket(Consumer<MessageType> sendAction, Runnable closeAction) {
        Objects.requireNonNull(sendAction, "sendAction must not be null");
        Objects.requireNonNull(closeAction, "closeAction must not be null");
        this.sendAction = sendAction;
        this.closeAction = closeAction;
    }

    public final void send(MessageType message) {
        this.sendAction.accept(message);
    }

    public final void close() {
        this.closeAction.run();
    }

    public void clearUserProperties() {
        this.userProperties.clear();
    }

    public void setUserProperty(String propertyId, Object value) {
        if (value == null) {
            this.userProperties.remove(propertyId);
        } else {
            this.userProperties.put(propertyId, value);
        }
    }

    public String getUserProperty(String propertyId) {
        return this.getUserProperty(propertyId, String.class);
    }

    public <PropertyType> PropertyType getUserProperty(String propertyId, Class<PropertyType> propertyType) {
        return (PropertyType)this.userProperties.get(propertyId);
    }
}

