/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.websockets.RetrieveInfo;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.tuples.Pair;
import io.reactivex.Flowable;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class Endpoint<MessageType> {
    private final EndpointStreamSource<MessageType> streamSource;
    private final Optional<Consumer<CloseReason>> closeAction;

    protected Endpoint(EndpointStreamSource<MessageType> streamSource) {
        this(streamSource, null);
    }

    protected Endpoint(EndpointStreamSource<MessageType> streamSource, Consumer<CloseReason> closeAction) {
        Objects.requireNonNull(streamSource, "streamSource must not be null");
        this.streamSource = streamSource;
        this.closeAction = Optional.ofNullable(closeAction);
    }

    public Flowable<WebSocket<MessageType>> connectedWebSockets() {
        return this.streamSource.connectingSockets;
    }

    public Flowable<IncomingMessage<MessageType, IncomingMessageMetaData<MessageType>>> messages() {
        return this.streamSource.messages.map(tuple -> {
            RetrieveInfo retrieveInfo = new RetrieveInfo((WebSocket)tuple._3);
            IncomingMessageMetaData meta = new IncomingMessageMetaData((String)tuple._2, retrieveInfo);
            return new IncomingMessage(tuple._1, meta);
        });
    }

    public Flowable<Pair<WebSocket<MessageType>, Throwable>> errors() {
        return this.streamSource.errors;
    }

    public Flowable<Pair<WebSocket<MessageType>, CloseReason>> closedWebSockets() {
        return this.streamSource.closingSockets;
    }

    public void close() {
        this.close(CloseReason.NORMAL_CLOSURE);
    }

    public void close(CloseReason closeReason) {
        if (!closeReason.mightBeUsedByEndpoint) {
            throw new IllegalArgumentException("CloseReason " + (Object)((Object)closeReason) + " cannot be used by endpoints");
        }
        this.closeAction.ifPresent(closeAction -> closeAction.accept(closeReason));
    }
}

