/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpoint;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpointFactory;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpoint;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpointFactory;
import com.ning.http.client.AsyncHttpClient;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.websockets.WebSocketAddOn;

public class WebSocketAdapter<MessageType> {
    private final HttpServer httpServer;
    private final AsyncHttpClient httpClient;
    private final MessageMarshaller<MessageType, String> messageMarshaller;
    private final MessageUnmarshaller<String, MessageType> messageUnmarshaller;
    private final MetricsCollector metricsCollector;
    private final ServerEndpointFactory serverEndpointFactory = new ServerEndpointFactory();

    private WebSocketAdapter(Builder<MessageType> builder) {
        this.messageMarshaller = builder.messageMarshaller;
        this.messageUnmarshaller = builder.messageUnmarshaller;
        this.metricsCollector = new MetricsCollector(builder.metrics);
        this.httpServer = ((Builder)builder).httpServer;
        if (this.httpServer != null) {
            WebSocketAddOn addon = new WebSocketAddOn();
            for (NetworkListener listener : this.httpServer.getListeners()) {
                listener.registerAddOn((AddOn)addon);
            }
        }
        this.httpClient = ((Builder)builder).httpClient;
    }

    public ClientEndpoint<MessageType> connectTo(String destination) {
        if (this.httpClient == null) {
            throw new IllegalStateException("Adapter not initialized properly for client mode");
        }
        return ClientEndpointFactory.createFor(this.httpClient, destination, this.messageMarshaller, this.messageUnmarshaller, this.metricsCollector);
    }

    public ServerEndpoint<MessageType> acceptConnections(String destination) {
        if (this.httpServer == null) {
            throw new IllegalStateException("Adapter not initialized properly for server mode");
        }
        return this.serverEndpointFactory.createFor(destination, this.messageMarshaller, this.messageUnmarshaller, this.metricsCollector);
    }

    public static <MessageType> Builder<MessageType> builder(Class<MessageType> messageTypeClass) {
        return new Builder(messageTypeClass);
    }

    public static class Builder<MessageType>
    extends CommAdapterBuilder<MessageType, WebSocketAdapter<MessageType>> {
        private HttpServer httpServer;
        private AsyncHttpClient httpClient;

        private Builder(Class<MessageType> messageTypeClass) {
            super(messageTypeClass);
        }

        public Builder<MessageType> setHttpClient(AsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder<MessageType> setHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public WebSocketAdapter<MessageType> createInstance() {
            this.validate();
            return new WebSocketAdapter(this);
        }
    }
}

