/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.client;

import ch.squaredesk.nova.comm.retrieving.MessageUnmarshaller;
import ch.squaredesk.nova.comm.sending.MessageMarshaller;
import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSourceFactory;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpoint;
import ch.squaredesk.nova.comm.websockets.client.StreamCreatingWebSocketTextListener;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.providers.grizzly.websocket.GrizzlyWebSocketAdapter;
import com.ning.http.client.ws.WebSocketUpgradeHandler;
import java.util.function.Consumer;
import java.util.function.Function;

public class ClientEndpointFactory {
    private ClientEndpointFactory() {
    }

    public static <MessageType> ClientEndpoint<MessageType> createFor(AsyncHttpClient httpClient, String destination, MessageMarshaller<MessageType, String> messageMarshaller, MessageUnmarshaller<String, MessageType> messageUnmarshaller, MetricsCollector metricsCollector) {
        StreamCreatingWebSocketTextListener<Object> listener = new StreamCreatingWebSocketTextListener<Object>(text -> ClientEndpointFactory.unmarshal(destination, text, messageUnmarshaller, metricsCollector));
        WebSocketUpgradeHandler webSocketUpgradeHandler = new WebSocketUpgradeHandler.Builder().addWebSocketListener(listener).build();
        com.ning.http.client.ws.WebSocket underlyingWebSocket = ClientEndpointFactory.openConnection(httpClient, destination, webSocketUpgradeHandler);
        WebSocket webSocket = ClientEndpointFactory.createWebSocket(destination, underlyingWebSocket, messageMarshaller, metricsCollector);
        Function<com.ning.http.client.ws.WebSocket, WebSocket> webSocketFactory = rawSocket -> webSocket;
        EndpointStreamSource endpointStreamSource = EndpointStreamSourceFactory.createStreamSourceFor(destination, webSocketFactory, listener, metricsCollector);
        Consumer<CloseReason> closeAction = closeReason -> {
            if (underlyingWebSocket instanceof GrizzlyWebSocketAdapter) {
                GrizzlyWebSocketAdapter gwsa = (GrizzlyWebSocketAdapter)underlyingWebSocket;
                gwsa.getGrizzlyWebSocket().close(closeReason.code, closeReason.text);
            } else {
                underlyingWebSocket.close();
            }
            listener.close();
        };
        return new ClientEndpoint(endpointStreamSource, webSocket, closeAction);
    }

    private static com.ning.http.client.ws.WebSocket openConnection(AsyncHttpClient httpClient, String destination, WebSocketUpgradeHandler webSocketUpgradeHandler) {
        try {
            return (com.ning.http.client.ws.WebSocket)httpClient.prepareGet(destination).execute((AsyncHandler)webSocketUpgradeHandler).get();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to connect to " + destination, e);
        }
    }

    private static <MessageType> WebSocket<MessageType> createWebSocket(String destination, com.ning.http.client.ws.WebSocket webSocket, MessageMarshaller<MessageType, String> messageMarshaller, MetricsCollector metricsCollector) {
        return new WebSocket<Object>(message -> {
            String messageAsString = ClientEndpointFactory.marshal(message, messageMarshaller);
            webSocket.sendMessage(messageAsString);
            metricsCollector.messageSent(destination);
        }, () -> metricsCollector.subscriptionDestroyed(destination));
    }

    private static <MessageType> String marshal(MessageType message, MessageMarshaller<MessageType, String> messageMarshaller) {
        try {
            return (String)messageMarshaller.marshal(message);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to marshal message " + message, e);
        }
    }

    private static <MessageType> MessageType unmarshal(String destination, String message, MessageUnmarshaller<String, MessageType> messageUnmarshaller, MetricsCollector metricsCollector) {
        try {
            return (MessageType)messageUnmarshaller.unmarshal((Object)message);
        }
        catch (Exception e) {
            metricsCollector.unparsableMessageReceived(destination);
            throw new RuntimeException("Unable to unmarshal incoming message " + message + " on destination " + destination, e);
        }
    }
}

