/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.retrieving.IncomingMessage;
import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.IncomingMessageMetaData;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.RetrieveInfo;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.tuples.Pair;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.util.Objects;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Endpoint {
    private static final Logger logger = LoggerFactory.getLogger(Endpoint.class);
    private final String destination;
    private final EndpointStreamSource streamSource;
    private final Consumer<CloseReason> closeAction;
    private final MessageTranscriber<String> messageTranscriber;
    private final MetricsCollector metricsCollector;

    protected Endpoint(String destination, EndpointStreamSource streamSource, MessageTranscriber<String> messageTranscriber, MetricsCollector metricsCollector) {
        this(destination, streamSource, null, messageTranscriber, metricsCollector);
    }

    protected Endpoint(String destination, EndpointStreamSource streamSource, Consumer<CloseReason> closeAction, MessageTranscriber<String> messageTranscriber, MetricsCollector metricsCollector) {
        Objects.requireNonNull(streamSource, "streamSource must not be null");
        this.destination = destination;
        this.streamSource = streamSource;
        this.closeAction = closeAction;
        this.messageTranscriber = messageTranscriber;
        this.metricsCollector = metricsCollector;
    }

    public Flowable<WebSocket> connectedWebSockets() {
        return this.streamSource.connectingSockets;
    }

    public <T> Flowable<IncomingMessage<T, IncomingMessageMetaData>> messages(Class<T> messageType) {
        if (this.messageTranscriber == null) {
            throw new IllegalArgumentException("Unable to get message transcriber for class " + messageType);
        }
        return this.messages(this.messageTranscriber.getIncomingMessageTranscriber(messageType));
    }

    public <T> Flowable<IncomingMessage<T, IncomingMessageMetaData>> messages(Function<String, T> messageTranscriber) {
        return this.streamSource.messages.map(tuple -> {
            Object message = null;
            IncomingMessageMetaData meta = null;
            try {
                String messageAsString = (String)tuple._1;
                message = messageTranscriber.apply((Object)messageAsString);
                RetrieveInfo retrieveInfo = new RetrieveInfo((WebSocket)tuple._3);
                meta = new IncomingMessageMetaData((String)tuple._2, retrieveInfo);
                this.metricsCollector.messageReceived(this.destination);
            }
            catch (Exception e) {
                logger.error("Unable to transcribe incoming message {} ", tuple._1, (Object)e);
                this.metricsCollector.unparsableMessageReceived(this.destination);
            }
            return new IncomingMessage(message, meta);
        }).filter(x -> x.message != null);
    }

    public Flowable<Pair<WebSocket, Throwable>> errors() {
        return this.streamSource.errors;
    }

    public Flowable<Pair<WebSocket, CloseReason>> closedWebSockets() {
        return this.streamSource.closingSockets;
    }

    public void close() {
        this.close(CloseReason.NORMAL_CLOSURE);
    }

    public void close(CloseReason closeReason) {
        if (!closeReason.mightBeUsedByEndpoint) {
            throw new IllegalArgumentException("CloseReason " + (Object)((Object)closeReason) + " cannot be used by endpoints");
        }
        if (this.closeAction != null) {
            this.closeAction.accept(closeReason);
        }
    }
}

