/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.websockets.SendAction;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class WebSocket {
    private final SendAction sendAction;
    private final Runnable closeAction;
    private final ConcurrentHashMap<String, Object> userProperties = new ConcurrentHashMap(1);

    public WebSocket(SendAction sendAction, Runnable closeAction) {
        Objects.requireNonNull(sendAction, "sendAction must not be null");
        Objects.requireNonNull(closeAction, "closeAction must not be null");
        this.sendAction = sendAction;
        this.closeAction = closeAction;
    }

    public final <T> void send(T message) throws Exception {
        this.sendAction.accept(message);
    }

    public final void close() {
        this.closeAction.run();
    }

    public void clearUserProperties() {
        this.userProperties.clear();
    }

    public void setUserProperty(String propertyId, Object value) {
        if (value == null) {
            this.userProperties.remove(propertyId);
        } else {
            this.userProperties.put(propertyId, value);
        }
    }

    public String getUserProperty(String propertyId) {
        return this.getUserProperty(propertyId, String.class);
    }

    public <PropertyType> PropertyType getUserProperty(String propertyId, Class<PropertyType> propertyType) {
        return (PropertyType)this.userProperties.get(propertyId);
    }
}

