/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.CommAdapter;
import ch.squaredesk.nova.comm.CommAdapterBuilder;
import ch.squaredesk.nova.comm.DefaultMessageTranscriberForStringAsTransportType;
import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpoint;
import ch.squaredesk.nova.comm.websockets.client.ClientEndpointFactory;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpoint;
import ch.squaredesk.nova.comm.websockets.server.ServerEndpointFactory;
import com.ning.http.client.AsyncHttpClient;
import org.glassfish.grizzly.http.server.AddOn;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.websockets.WebSocketAddOn;

public class WebSocketAdapter
extends CommAdapter<String> {
    private final HttpServer httpServer;
    private final AsyncHttpClient httpClient;
    private final MetricsCollector metricsCollector;
    private final ServerEndpointFactory serverEndpointFactory;
    private final ClientEndpointFactory clientEndpointFactory;

    private WebSocketAdapter(Builder builder) {
        super(builder.messageTranscriber, builder.metrics);
        this.metricsCollector = new MetricsCollector(builder.metrics);
        this.httpServer = builder.httpServer;
        if (this.httpServer != null) {
            WebSocketAddOn addon = new WebSocketAddOn();
            for (NetworkListener listener : this.httpServer.getListeners()) {
                listener.registerAddOn((AddOn)addon);
            }
        }
        this.httpClient = builder.httpClient;
        this.serverEndpointFactory = new ServerEndpointFactory((MessageTranscriber<String>)builder.messageTranscriber);
        this.clientEndpointFactory = new ClientEndpointFactory((MessageTranscriber<String>)builder.messageTranscriber);
    }

    public ClientEndpoint connectTo(String destination) {
        if (this.httpClient == null) {
            throw new IllegalStateException("Adapter not initialized properly for client mode");
        }
        return this.clientEndpointFactory.createFor(this.httpClient, destination, this.metricsCollector);
    }

    public ServerEndpoint acceptConnections(String destination) {
        if (this.httpServer == null) {
            throw new IllegalStateException("Adapter not initialized properly for server mode");
        }
        return this.serverEndpointFactory.createFor(destination, this.metricsCollector);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CommAdapterBuilder<String, WebSocketAdapter> {
        private HttpServer httpServer;
        private AsyncHttpClient httpClient;

        private Builder() {
        }

        public Builder setHttpClient(AsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public Builder setHttpServer(HttpServer httpServer) {
            this.httpServer = httpServer;
            return this;
        }

        public WebSocketAdapter createInstance() {
            this.validate();
            if (this.messageTranscriber == null) {
                this.messageTranscriber = new DefaultMessageTranscriberForStringAsTransportType();
            }
            return new WebSocketAdapter(this);
        }
    }
}

