/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.client;

import ch.squaredesk.nova.comm.MessageTranscriber;
import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.Endpoint;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import java.util.function.Consumer;

public class ClientEndpoint
extends Endpoint {
    private final WebSocket webSocket;

    public ClientEndpoint(String destination, EndpointStreamSource endpointStreamSource, WebSocket webSocket, Consumer<CloseReason> closeAction, MessageTranscriber<String> messageTranscriber, MetricsCollector metricsCollector) {
        super(destination, endpointStreamSource, closeAction, messageTranscriber, metricsCollector);
        this.webSocket = webSocket;
    }

    public <T> void send(T message) throws Exception {
        this.webSocket.send(message);
    }

    public String getUserProperty(String propertyId) {
        return this.getUserProperty(propertyId, String.class);
    }

    public <PropertyType> PropertyType getUserProperty(String propertyId, Class<PropertyType> propertyType) {
        return this.webSocket.getUserProperty(propertyId, propertyType);
    }

    public void setUserProperty(String propertyId, Object value) {
        this.webSocket.setUserProperty(propertyId, value);
    }

    public void clearUserProperties() {
        this.webSocket.clearUserProperties();
    }
}

