/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets.client;

import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.StreamCreatingEndpointWrapper;
import ch.squaredesk.nova.tuples.Pair;
import com.ning.http.client.ws.WebSocket;
import com.ning.http.client.ws.WebSocketCloseCodeReasonListener;
import com.ning.http.client.ws.WebSocketTextListener;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCreatingWebSocketTextListener
implements WebSocketTextListener,
WebSocketCloseCodeReasonListener,
StreamCreatingEndpointWrapper<WebSocket> {
    private static final Logger logger = LoggerFactory.getLogger(StreamCreatingEndpointWrapper.class);
    private final Subject<Pair<WebSocket, String>> messages = PublishSubject.create();
    private final Subject<WebSocket> connectedSockets = BehaviorSubject.create();
    private final Subject<Pair<WebSocket, CloseReason>> closedSockets = PublishSubject.create();
    private final Subject<Pair<WebSocket, Throwable>> errors = PublishSubject.create();

    StreamCreatingWebSocketTextListener() {
    }

    public void onMessage(String messageText) {
        this.messages.onNext((Object)new Pair(null, (Object)messageText));
    }

    public void onOpen(WebSocket websocket) {
        this.connectedSockets.onNext((Object)websocket);
    }

    public void onClose(WebSocket websocket) {
    }

    public void onClose(WebSocket websocket, int code, String reason) {
        CloseReason closeReason;
        logger.trace("onClose() invoked with webSocket={}, code={}, reason={}.", new Object[]{websocket, code, reason});
        try {
            closeReason = CloseReason.forCloseCode(code);
        }
        catch (Exception e) {
            closeReason = CloseReason.NO_STATUS_CODE;
        }
        this.closedSockets.onNext((Object)new Pair((Object)websocket, (Object)closeReason));
    }

    public void onError(Throwable t) {
        this.errors.onNext((Object)new Pair(null, (Object)t));
    }

    @Override
    public Flowable<Pair<WebSocket, String>> messages() {
        return this.messages.toFlowable(BackpressureStrategy.BUFFER);
    }

    @Override
    public Flowable<WebSocket> connectingSockets() {
        return this.connectedSockets.toFlowable(BackpressureStrategy.BUFFER);
    }

    @Override
    public Flowable<Pair<WebSocket, CloseReason>> closingSockets() {
        return this.closedSockets.toFlowable(BackpressureStrategy.BUFFER);
    }

    @Override
    public Flowable<Pair<WebSocket, Throwable>> errors() {
        return this.errors.toFlowable(BackpressureStrategy.BUFFER);
    }

    void close() {
        this.messages.onComplete();
        this.connectedSockets.onComplete();
        this.errors.onComplete();
    }
}

