/*
 * Decompiled with CFR 0.152.
 */
package ch.squaredesk.nova.comm.websockets;

import ch.squaredesk.nova.comm.websockets.CloseReason;
import ch.squaredesk.nova.comm.websockets.EndpointStreamSource;
import ch.squaredesk.nova.comm.websockets.MetricsCollector;
import ch.squaredesk.nova.comm.websockets.StreamCreatingEndpointWrapper;
import ch.squaredesk.nova.comm.websockets.WebSocket;
import ch.squaredesk.nova.tuples.Pair;
import ch.squaredesk.nova.tuples.Tuple3;
import io.reactivex.Flowable;
import io.reactivex.functions.Function;

public class EndpointStreamSourceFactory {
    private EndpointStreamSourceFactory() {
    }

    public static <SomeWebSocketType> EndpointStreamSource createStreamSourceFor(String destination, Function<SomeWebSocketType, WebSocket> webSocketFactory, StreamCreatingEndpointWrapper<SomeWebSocketType> streamCreatingEndpointWrapper, MetricsCollector metricsCollector) {
        Flowable messages = streamCreatingEndpointWrapper.messages().map(pair -> new Tuple3((Object)((String)pair._2), (Object)destination, (Object)((WebSocket)webSocketFactory.apply(pair._1))));
        Flowable connectingSockets = streamCreatingEndpointWrapper.connectingSockets().map(arg_0 -> webSocketFactory.apply(arg_0)).doOnNext(socket -> metricsCollector.subscriptionCreated(destination));
        Flowable closingSockets = streamCreatingEndpointWrapper.closingSockets().map(pair -> new Pair((Object)((WebSocket)webSocketFactory.apply(pair._1)), (Object)((CloseReason)((Object)((Object)pair._2))))).doOnNext(socket -> metricsCollector.subscriptionDestroyed(destination));
        Flowable errors = streamCreatingEndpointWrapper.errors().map(pair -> new Pair((Object)((WebSocket)webSocketFactory.apply(pair._1)), (Object)((Throwable)pair._2)));
        return new EndpointStreamSource((Flowable<Tuple3<String, String, WebSocket>>)messages, (Flowable<WebSocket>)connectingSockets, (Flowable<Pair<WebSocket, CloseReason>>)closingSockets, (Flowable<Pair<WebSocket, Throwable>>)errors);
    }
}

